/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.preproc;

import antlr.CommonASTWithHiddenTokens;
import antlr.CommonHiddenStreamToken;
import antlr.collections.AST;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.BitSet;
import java.util.Stack;
import processing.app.Preferences;
import processing.app.SketchException;
import processing.mode.java.preproc.PdePreprocessor;
import processing.mode.java.preproc.PdeTokenTypes;
import processing.mode.java.preproc.TokenUtil;

public class PdeEmitter
implements PdeTokenTypes {
    private final PdePreprocessor pdePreprocessor;
    private final PrintWriter out;
    private final PrintStream debug = System.err;
    private final Stack<AST> stack = new Stack();
    private static final int ROOT_ID = 0;
    private static final BitSet OTHER_COPIED_TOKENS = new BitSet(){
        {
            this.set(73);
            this.set(75);
            this.set(76);
            this.set(77);
        }
    };

    public PdeEmitter(PdePreprocessor pdePreprocessor, PrintWriter out) {
        this.pdePreprocessor = pdePreprocessor;
        this.out = out;
    }

    private AST getChild(AST ast, int childType) {
        AST child = ast.getFirstChild();
        while (child != null) {
            if (child.getType() == childType) {
                return child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    private void dumpHiddenAfter(AST ast) {
        this.dumpHiddenTokens(((CommonASTWithHiddenTokens)ast).getHiddenAfter());
    }

    private void dumpHiddenBefore(AST ast) {
        CommonHiddenStreamToken child = null;
        CommonHiddenStreamToken parent = ((CommonASTWithHiddenTokens)ast).getHiddenBefore();
        if (parent == null) {
            return;
        }
        while ((parent = (child = parent).getHiddenBefore()) != null) {
        }
        this.dumpHiddenTokens(child);
    }

    private void dumpHiddenTokens(CommonHiddenStreamToken t) {
        while (t != null) {
            this.out.print(t.getText());
            t = this.pdePreprocessor.getHiddenAfter(t);
        }
    }

    private boolean printChildren(AST ast) throws SketchException {
        boolean ret = false;
        AST child = ast.getFirstChild();
        while (child != null) {
            ret = true;
            this.print(child);
            child = child.getNextSibling();
        }
        return ret;
    }

    private boolean hasChildren(AST ast) {
        return ast.getFirstChild() != null;
    }

    private AST getBestPrintableNode(AST ast, boolean includeThisNode) {
        AST child = includeThisNode ? ast : ast.getFirstChild();
        if (child != null) {
            switch (child.getType()) {
                case 14: 
                case 31: 
                case 32: 
                case 94: 
                case 112: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 124: 
                case 152: 
                case 153: 
                case 154: 
                case 155: 
                case 159: {
                    return child;
                }
                case 5: {
                    if (child.getFirstChild() == null) {
                        return this.getBestPrintableNode(child.getNextSibling(), false);
                    }
                    return this.getBestPrintableNode(child, false);
                }
            }
            return this.getBestPrintableNode(child, false);
        }
        return ast;
    }

    private void printBinaryOperator(AST ast) throws SketchException {
        this.print(ast.getFirstChild());
        if (!OTHER_COPIED_TOKENS.get(ast.getType())) {
            this.out.print(ast.getText());
            this.dumpHiddenAfter(ast);
        }
        this.print(ast.getFirstChild().getNextSibling());
    }

    private void printMethodDef(AST ast) throws SketchException {
        AST type;
        AST modifiers = ast.getFirstChild();
        if (modifiers.getNextSibling().getType() == 57) {
            AST typeParameters = modifiers.getNextSibling();
            type = typeParameters.getNextSibling();
        } else {
            Object typeParameters = null;
            type = modifiers.getNextSibling();
        }
        AST methodName = type.getNextSibling();
        this.pdePreprocessor.addMethod(methodName.getText());
        this.printChildren(ast);
    }

    private void printIfThenElse(AST literalIf) throws SketchException {
        this.out.print(literalIf.getText());
        this.dumpHiddenAfter(literalIf);
        AST condition = literalIf.getFirstChild();
        this.print(condition);
        AST thenPath = condition.getNextSibling();
        this.print(thenPath);
        AST elsePath = thenPath.getNextSibling();
        if (elsePath != null) {
            this.out.print("else");
            AST bestPrintableNode = this.getBestPrintableNode(elsePath, true);
            this.dumpHiddenBefore(bestPrintableNode);
            CommonHiddenStreamToken hiddenBefore = ((CommonASTWithHiddenTokens)elsePath).getHiddenBefore();
            if (elsePath.getType() == 7 && elsePath.getNumberOfChildren() == 0 && hiddenBefore == null) {
                this.out.print("{");
                CommonHiddenStreamToken hiddenAfter = ((CommonASTWithHiddenTokens)elsePath).getHiddenAfter();
                if (hiddenAfter == null) {
                    this.out.print("}");
                } else {
                    this.dumpHiddenTokens(hiddenAfter);
                }
            } else {
                this.print(elsePath);
            }
        }
    }

    public void print(AST ast) throws SketchException {
        if (ast == null) {
            return;
        }
        this.stack.push(ast);
        AST child1 = ast.getFirstChild();
        AST child2 = null;
        AST child3 = null;
        if (child1 != null && (child2 = child1.getNextSibling()) != null) {
            child3 = child2.getNextSibling();
        }
        switch (ast.getType()) {
            case 0: {
                this.dumpHiddenTokens(this.pdePreprocessor.getInitialHiddenToken());
                this.printChildren(ast);
                break;
            }
            case 16: {
                this.out.print("package");
                this.dumpHiddenAfter(ast);
                this.print(ast.getFirstChild());
                break;
            }
            case 30: {
                this.out.print("import");
                this.dumpHiddenAfter(ast);
                this.print(ast.getFirstChild());
                break;
            }
            case 45: {
                this.out.print("import static");
                this.dumpHiddenAfter(ast);
                this.print(ast.getFirstChild());
                break;
            }
            case 14: 
            case 15: {
                this.print(this.getChild(ast, 5));
                if (ast.getType() == 14) {
                    this.out.print("class");
                } else {
                    this.out.print("interface");
                }
                this.dumpHiddenBefore(this.getChild(ast, 68));
                this.print(this.getChild(ast, 68));
                this.print(this.getChild(ast, 57));
                this.print(this.getChild(ast, 18));
                this.print(this.getChild(ast, 19));
                this.print(this.getChild(ast, 6));
                break;
            }
            case 18: {
                if (!this.hasChildren(ast)) break;
                this.out.print("extends");
                this.dumpHiddenBefore(this.getBestPrintableNode(ast, false));
                this.printChildren(ast);
                break;
            }
            case 19: {
                if (!this.hasChildren(ast)) break;
                this.out.print("implements");
                this.dumpHiddenBefore(this.getBestPrintableNode(ast, false));
                this.printChildren(ast);
                break;
            }
            case 69: {
                this.print(child1);
                this.out.print(".");
                this.dumpHiddenAfter(ast);
                this.print(child2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 44: {
                this.printChildren(ast);
                break;
            }
            case 9: {
                this.printMethodDef(ast);
                break;
            }
            case 99: {
                if (child2 != null) {
                    this.print(child1);
                    this.out.print("=");
                    this.dumpHiddenAfter(ast);
                    this.print(child2);
                    break;
                }
                this.out.print("=");
                this.dumpHiddenAfter(ast);
                this.print(child1);
                break;
            }
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 105: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: {
                this.printBinaryOperator(ast);
                break;
            }
            case 122: {
                this.out.print(ast.getText());
                this.dumpHiddenAfter(ast);
                if (child1.getType() == 48) {
                    this.printChildren(child1);
                    this.print(child2);
                    break;
                }
                this.printChildren(ast);
                break;
            }
            case 25: 
            case 26: {
                this.print(child1);
                this.out.print(ast.getText());
                this.dumpHiddenAfter(ast);
                break;
            }
            case 31: 
            case 32: 
            case 152: 
            case 153: 
            case 154: 
            case 155: {
                this.out.print(ast.getText());
                this.dumpHiddenAfter(ast);
                this.print(child1);
                break;
            }
            case 159: {
                this.out.print("new");
                this.dumpHiddenAfter(ast);
                this.printChildren(ast);
                break;
            }
            case 118: {
                this.out.print("return");
                this.dumpHiddenAfter(ast);
                this.print(child1);
                break;
            }
            case 12: {
                this.out.print("static");
                this.dumpHiddenBefore(this.getBestPrintableNode(ast, false));
                this.print(child1);
                break;
            }
            case 119: {
                this.out.print("switch");
                this.dumpHiddenAfter(ast);
                this.printChildren(ast);
                break;
            }
            case 22: 
            case 33: {
                this.printChildren(ast);
                break;
            }
            case 123: {
                this.out.print("case");
                this.dumpHiddenAfter(ast);
                this.printChildren(ast);
                break;
            }
            case 106: {
                this.out.print("default");
                this.dumpHiddenAfter(ast);
                this.printChildren(ast);
                break;
            }
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: {
                this.out.print(ast.getText());
                this.dumpHiddenAfter(ast);
                break;
            }
            case 94: 
            case 121: {
                this.out.print(ast.getText());
                this.dumpHiddenAfter(ast);
                this.printChildren(ast);
                break;
            }
            case 39: 
            case 40: 
            case 62: 
            case 63: 
            case 65: 
            case 72: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 102: 
            case 108: 
            case 156: 
            case 157: 
            case 158: {
                this.out.print(ast.getText());
                this.dumpHiddenAfter(ast);
                break;
            }
            case 38: 
            case 175: {
                break;
            }
            case 116: 
            case 117: {
                this.out.print(ast.getText());
                this.dumpHiddenAfter(ast);
                if (child1 == null) break;
                this.print(child1);
                break;
            }
            case 87: {
                if (this.hasChildren(ast)) {
                    this.printBinaryOperator(ast);
                    break;
                }
                this.out.print("*");
                this.dumpHiddenAfter(ast);
                break;
            }
            case 109: {
                this.out.print("throws");
                this.dumpHiddenAfter(ast);
                this.printChildren(ast);
                break;
            }
            case 112: {
                this.printIfThenElse(ast);
                break;
            }
            case 114: {
                this.out.print("while");
                this.dumpHiddenAfter(ast);
                this.printChildren(ast);
                break;
            }
            case 115: {
                this.out.print("do");
                this.dumpHiddenAfter(ast);
                this.print(child1);
                this.out.print("while");
                this.dumpHiddenBefore(this.getBestPrintableNode(child2, false));
                this.print(child2);
                break;
            }
            case 124: {
                this.out.print("try");
                this.dumpHiddenAfter(ast);
                this.printChildren(ast);
                break;
            }
            case 126: {
                this.out.print("catch");
                this.dumpHiddenAfter(ast);
                this.printChildren(ast);
                break;
            }
            case 125: {
                this.out.print("finally");
                this.dumpHiddenAfter(ast);
                this.printChildren(ast);
                break;
            }
            case 120: {
                this.out.print("throw");
                this.dumpHiddenAfter(ast);
                this.print(child1);
                break;
            }
            case 70: {
                this.print(child1);
                this.out.print("?");
                this.dumpHiddenAfter(ast);
                this.print(child2);
                this.print(child3);
                break;
            }
            case 68: {
                this.out.print(ast.getText());
                this.dumpHiddenAfter(ast);
                break;
            }
            case 177: {
                this.out.print("int");
                this.dumpHiddenAfter(ast);
                break;
            }
            case 176: {
                if (ast.getText().length() != 6) {
                    System.err.println("Internal error: incorrect length of webcolor literal should have been detected sooner.");
                    break;
                }
                this.out.print("0xff" + ast.getText());
                this.dumpHiddenAfter(ast);
                break;
            }
            case 174: {
                AST terminalTypeNode = child1.getFirstChild();
                AST exprToCast = child2;
                String pooType = terminalTypeNode.getText();
                this.out.print("PApplet.parse" + Character.toUpperCase(pooType.charAt(0)) + pooType.substring(1));
                this.dumpHiddenAfter(terminalTypeNode);
                this.print(exprToCast);
                break;
            }
            case 165: {
                String literalDouble = ast.getText().toLowerCase();
                this.out.print(literalDouble);
                if (Preferences.getBoolean("preproc.substitute_floats") && literalDouble.indexOf(100) == -1) {
                    this.out.print("f");
                }
                this.dumpHiddenAfter(ast);
                break;
            }
            case 55: 
            case 57: {
                this.printChildren(ast);
                break;
            }
            case 56: 
            case 58: {
                this.printChildren(ast);
                break;
            }
            case 59: {
                this.out.print(ast.getText());
                this.dumpHiddenAfter(ast);
                this.print(ast.getFirstChild());
                break;
            }
            case 60: 
            case 61: {
                this.out.print(ast.getType() == 61 ? "super" : "extends");
                this.dumpHiddenBefore(this.getBestPrintableNode(ast, false));
                this.printChildren(ast);
                break;
            }
            case 51: {
                this.out.print("@");
                this.printChildren(ast);
                break;
            }
            case 54: {
                this.printChildren(ast);
                break;
            }
            case 52: {
                this.print(ast.getFirstChild());
                this.out.print("=");
                this.dumpHiddenBefore(this.getBestPrintableNode(ast.getFirstChild().getNextSibling(), false));
                this.print(ast.getFirstChild().getNextSibling());
                break;
            }
            default: {
                this.debug.println("Unrecognized type:" + ast.getType() + " (" + TokenUtil.nameOf(ast) + ")");
            }
        }
        this.stack.pop();
    }
}

