/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.preproc;

import antlr.ASTFactory;
import antlr.BaseAST;
import antlr.CommonAST;
import antlr.CommonASTWithHiddenTokens;
import antlr.CommonHiddenStreamToken;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStreamCopyingHiddenTokenFilter;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import processing.app.Base;
import processing.app.Preferences;
import processing.app.SketchException;
import processing.core.PApplet;
import processing.mode.java.preproc.PdeEmitter;
import processing.mode.java.preproc.PdeLexer;
import processing.mode.java.preproc.PdeRecognizer;
import processing.mode.java.preproc.PreprocessorResult;
import processing.mode.java.preproc.TokenUtil;

public class PdePreprocessor {
    protected static final String UNICODE_ESCAPES = "0123456789abcdefABCDEF";
    private static final int ROOT_ID = 0;
    protected final String indent;
    private final String name;
    private TokenStreamCopyingHiddenTokenFilter filter;
    private String advClassName = "";
    protected Mode mode;
    HashMap<String, Object> foundMethods;
    protected String sizeStatement;
    protected String sketchWidth;
    protected String sketchHeight;
    protected String sketchRenderer;
    public static final String SIZE_REGEX = "(?:^|\\s|;)size\\s*\\(\\s*([^\\s,]+)\\s*,\\s*([^\\s,\\)]+),?\\s*([^\\)]*)\\s*\\)\\s*\\;";
    private static final Pattern PUBLIC_CLASS = Pattern.compile("(^|;)\\s*public\\s+class\\s+\\S+\\s+extends\\s+PApplet", 8);
    private static final Pattern FUNCTION_DECL = Pattern.compile("(^|;)\\s*((public|private|protected|final|static)\\s+)*(void|int|float|double|String|char|byte)(\\s*\\[\\s*\\])?\\s+[a-zA-Z0-9]+\\s*\\(", 8);

    public PdePreprocessor(String sketchName) {
        this(sketchName, Preferences.getInteger("editor.tabs.size"));
    }

    public PdePreprocessor(String sketchName, int tabSize) {
        this.name = sketchName;
        char[] indentChars = new char[tabSize];
        Arrays.fill(indentChars, ' ');
        this.indent = new String(indentChars);
    }

    public String[] initSketchSize(String code, boolean sizeWarning) throws SketchException {
        String[] info = PdePreprocessor.parseSketchSize(code, sizeWarning);
        if (info != null) {
            this.sizeStatement = info[0];
            this.sketchWidth = info[1];
            this.sketchHeight = info[2];
            this.sketchRenderer = info[3];
        }
        return info;
    }

    public static String[] parseSketchSize(String code, boolean fussy) {
        String[] matches = PApplet.match((String)PdePreprocessor.scrubComments(code), (String)SIZE_REGEX);
        if (matches != null) {
            boolean badSize = false;
            if (matches[1].equals("screenWidth") || matches[1].equals("screenHeight") || matches[2].equals("screenWidth") || matches[2].equals("screenHeight")) {
                Base.showWarning("Time for a quick update", "The screenWidth and screenHeight variables\nare named displayWidth and displayHeight\nin this release of Processing.", null);
                return null;
            }
            if (!matches[1].equals("displayWidth") && !matches[1].equals("displayHeight") && PApplet.parseInt((String)matches[1], (int)-1) == -1) {
                badSize = true;
            }
            if (!matches[2].equals("displayWidth") && !matches[2].equals("displayHeight") && PApplet.parseInt((String)matches[2], (int)-1) == -1) {
                badSize = true;
            }
            if (badSize && fussy) {
                Base.showWarning("Could not find sketch size", "The size of this applet could not automatically\nbe determined from your code. Use only numeric\nvalues (not variables) for the size() command.\nSee the size() reference for an explanation.", null);
                return null;
            }
            matches[3] = matches[3].trim();
            if (matches[3].length() == 0) {
                matches[3] = null;
            }
            return matches;
        }
        return new String[4];
    }

    public static String scrubComments(String what) {
        char[] p = what.toCharArray();
        boolean insideQuote = false;
        int index = 0;
        while (index < p.length) {
            if (!insideQuote && p[index] == '/' && index < p.length - 1 && p[index + 1] == '/') {
                p[index++] = 32;
                p[index++] = 32;
                while (index < p.length && p[index] != '\n') {
                    p[index++] = 32;
                }
                continue;
            }
            if (!insideQuote && p[index] == '/' && index < p.length - 1 && p[index + 1] == '*') {
                p[index++] = 32;
                p[index++] = 32;
                boolean endOfRainbow = false;
                while (index < p.length - 1) {
                    if (p[index] == '*' && p[index + 1] == '/') {
                        p[index++] = 32;
                        p[index++] = 32;
                        endOfRainbow = true;
                        break;
                    }
                    p[index++] = 32;
                }
                if (endOfRainbow) continue;
                throw new RuntimeException("Missing the */ from the end of a /* comment */");
            }
            if (p[index] == '\"' && index > 0 && p[index - 1] != '\\') {
                insideQuote = !insideQuote;
                ++index;
                continue;
            }
            ++index;
        }
        return new String(p);
    }

    public void addMethod(String methodName) {
        this.foundMethods.put(methodName, new Object());
    }

    public boolean hasMethod(String methodName) {
        return this.foundMethods.containsKey(methodName);
    }

    public void setAdvClassName(String advClassName) {
        this.advClassName = advClassName;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    CommonHiddenStreamToken getHiddenAfter(CommonHiddenStreamToken t) {
        return this.filter.getHiddenAfter(t);
    }

    CommonHiddenStreamToken getInitialHiddenToken() {
        return this.filter.getInitialHiddenToken();
    }

    private static int countNewlines(String s) {
        int count = 0;
        int pos = s.indexOf(10, 0);
        while (pos >= 0) {
            ++count;
            pos = s.indexOf(10, pos + 1);
        }
        return count;
    }

    private static void checkForUnterminatedMultilineComment(String program) throws SketchException {
        int length = program.length();
        int i = 0;
        while (i < length) {
            boolean terminated;
            if (program.charAt(i) == '/' && i < length - 1 && program.charAt(i + 1) == '/') {
                i += 2;
                while (i < length && program.charAt(i) != '\n') {
                    ++i;
                }
            } else if (program.charAt(i) == '/' && i < length - 1 && program.charAt(i + 1) == '*') {
                int startOfComment = i;
                i += 2;
                terminated = false;
                while (i < length - 1) {
                    if (program.charAt(i) == '*' && program.charAt(i + 1) == '/') {
                        i += 2;
                        terminated = true;
                        break;
                    }
                    ++i;
                }
                if (!terminated) {
                    throw new SketchException("Unclosed /* comment */", 0, PdePreprocessor.countNewlines(program.substring(0, startOfComment)));
                }
            } else if (program.charAt(i) == '\"') {
                int stringStart = i++;
                terminated = false;
                while (i < length) {
                    char c = program.charAt(i);
                    if (c == '\"') {
                        terminated = true;
                        break;
                    }
                    if (c == '\\') {
                        if (i == length - 1) break;
                        ++i;
                    } else if (c == '\n') break;
                    ++i;
                }
                if (!terminated) {
                    throw new SketchException("Unterminated string constant", 0, PdePreprocessor.countNewlines(program.substring(0, stringStart)));
                }
            } else if (program.charAt(i) == '\'') {
                if (++i >= length) {
                    throw new SketchException("Unterminated character constant (after initial quote)", 0, PdePreprocessor.countNewlines(program.substring(0, i)));
                }
                boolean escaped = false;
                if (program.charAt(i) == '\\') {
                    ++i;
                    escaped = true;
                }
                if (i >= length) {
                    throw new SketchException("Unterminated character constant (after backslash)", 0, PdePreprocessor.countNewlines(program.substring(0, i)));
                }
                if (escaped && program.charAt(i) == 'u') {
                    ++i;
                    int j = 0;
                    while (j < 4) {
                        if (UNICODE_ESCAPES.indexOf(program.charAt(i)) == -1) {
                            throw new SketchException("Bad or unfinished \\uXXXX sequence (malformed Unicode character constant)", 0, PdePreprocessor.countNewlines(program.substring(0, i)));
                        }
                        ++i;
                        ++j;
                    }
                } else {
                    ++i;
                }
                if (i >= length) {
                    throw new SketchException("Unterminated character constant", 0, PdePreprocessor.countNewlines(program.substring(0, i)));
                }
                if (program.charAt(i) != '\'') {
                    throw new SketchException("Badly formed character constant (expecting quote, got " + program.charAt(i) + ")", 0, PdePreprocessor.countNewlines(program.substring(0, i)));
                }
            }
            ++i;
        }
    }

    public PreprocessorResult write(Writer out, String program) throws SketchException, RecognitionException, TokenStreamException {
        return this.write(out, program, null);
    }

    public PreprocessorResult write(Writer out, String program, String[] codeFolderPackages) throws SketchException, RecognitionException, TokenStreamException {
        ArrayList<String> programImports = new ArrayList<String>();
        ArrayList<String> codeFolderImports = new ArrayList<String>();
        this.foundMethods = new HashMap();
        if (!program.endsWith("\n")) {
            program = String.valueOf(program) + "\n";
        }
        PdePreprocessor.checkForUnterminatedMultilineComment(program);
        if (Preferences.getBoolean("preproc.substitute_unicode")) {
            program = PdePreprocessor.substituteUnicode(program);
        }
        Pattern importPattern = Pattern.compile("((?:^|;|\\})\\s*)(import\\s+)((?:static\\s+)?\\S+)(\\s*;)");
        String scrubbed = PdePreprocessor.scrubComments(program);
        Matcher m = null;
        int offset = 0;
        boolean found = false;
        do {
            if (!(found = (m = importPattern.matcher(scrubbed)).find(offset))) continue;
            String before = m.group(1);
            String piece = String.valueOf(m.group(2)) + m.group(3) + m.group(4);
            if (!this.ignoreImport(m.group(3))) {
                programImports.add(m.group(3));
            }
            int start = m.start() + before.length();
            int stop = start + piece.length();
            program = String.valueOf(program.substring(0, start)) + program.substring(stop);
            scrubbed = String.valueOf(scrubbed.substring(0, start)) + scrubbed.substring(stop);
            offset = m.start();
        } while (found);
        if (codeFolderPackages != null) {
            String[] stringArray = codeFolderPackages;
            int n = codeFolderPackages.length;
            int piece = 0;
            while (piece < n) {
                String item = stringArray[piece];
                codeFolderImports.add(String.valueOf(item) + ".*");
                ++piece;
            }
        }
        PrintWriter stream = new PrintWriter(out);
        int headerOffset = this.writeImports(stream, programImports, codeFolderImports);
        return new PreprocessorResult(this.mode, headerOffset + 2, this.write(program, stream), programImports);
    }

    static String substituteUnicode(String program) {
        char[] p = program.toCharArray();
        int unicodeCount = 0;
        int i = 0;
        while (i < p.length) {
            if (p[i] > '\u007f') {
                ++unicodeCount;
            }
            ++i;
        }
        if (unicodeCount == 0) {
            return program;
        }
        int index = 0;
        char[] p2 = new char[p.length + unicodeCount * 5];
        int i2 = 0;
        while (i2 < p.length) {
            if (p[i2] < '\u0080') {
                p2[index++] = p[i2];
            } else if (p[i2] == '\u00a0') {
                p2[index++] = 32;
            } else {
                char c = p[i2];
                p2[index++] = 92;
                p2[index++] = 117;
                char[] str = Integer.toHexString(c).toCharArray();
                int m = 0;
                while (m < 4 - str.length) {
                    p2[index++] = 48;
                    ++m;
                }
                System.arraycopy(str, 0, p2, index, str.length);
                index += str.length;
            }
            ++i2;
        }
        return new String(p2, 0, index);
    }

    private String write(String program, PrintWriter stream) throws SketchException, RecognitionException, TokenStreamException {
        String uncomment = PdePreprocessor.scrubComments(program);
        PdeRecognizer parser = this.createParser(program);
        if (PUBLIC_CLASS.matcher(uncomment).find()) {
            try {
                PrintStream saved = System.err;
                try {
                    System.setErr(new PrintStream(new ByteArrayOutputStream()));
                    parser.javaProgram();
                }
                finally {
                    System.setErr(saved);
                }
                this.setMode(Mode.JAVA);
            }
            catch (Exception exception) {
                parser = this.createParser(program);
                parser.pdeProgram();
            }
        } else if (FUNCTION_DECL.matcher(uncomment).find()) {
            this.setMode(Mode.ACTIVE);
            parser.activeProgram();
        } else {
            parser.pdeProgram();
        }
        ASTFactory factory = new ASTFactory();
        AST parserAST = parser.getAST();
        AST rootNode = factory.create(0, "AST ROOT");
        rootNode.setFirstChild(parserAST);
        this.makeSimpleMethodsPublic(rootNode);
        BaseAST.setVerboseStringConversion((boolean)true, (String[])parser.getTokenNames());
        String className = this.mode == Mode.JAVA ? this.getFirstClassName(parserAST) : this.name;
        if (className == null) {
            return null;
        }
        this.writeDeclaration(stream, className);
        new PdeEmitter(this, stream).print(rootNode);
        this.writeFooter(stream, className);
        if (Preferences.getBoolean("preproc.output_parse_tree")) {
            this.writeParseTree("parseTree.xml", parserAST);
        }
        return className;
    }

    private PdeRecognizer createParser(String program) {
        PdeLexer lexer = new PdeLexer(new StringReader(program));
        lexer.setTokenObjectClass("antlr.CommonHiddenStreamToken");
        this.filter = new TokenStreamCopyingHiddenTokenFilter(lexer);
        this.filter.hide(167);
        this.filter.hide(168);
        this.filter.hide(166);
        this.filter.copy(63);
        this.filter.copy(97);
        this.filter.copy(98);
        this.filter.copy(100);
        this.filter.copy(101);
        this.filter.copy(74);
        this.filter.copy(67);
        this.filter.copy(66);
        this.filter.copy(111);
        this.filter.copy(110);
        this.filter.copy(73);
        this.filter.copy(75);
        this.filter.copy(76);
        this.filter.copy(77);
        PdeRecognizer parser = new PdeRecognizer(this, this.filter);
        parser.setASTNodeClass("antlr.ExtendedCommonASTWithHiddenTokens");
        return parser;
    }

    private void makeSimpleMethodsPublic(AST node) {
        if (node.getType() == 9) {
            AST oldFirstMod;
            AST mods = node.getFirstChild();
            AST mod = oldFirstMod = mods.getFirstChild();
            while (mod != null) {
                int t = mod.getType();
                if (t == 88 || t == 90 || t == 89) {
                    return;
                }
                mod = mod.getNextSibling();
            }
            if (mods.getNextSibling().getType() == 57) {
                return;
            }
            CommonHiddenStreamToken publicToken = new CommonHiddenStreamToken(89, "public"){
                {
                    this.setHiddenAfter(new CommonHiddenStreamToken(166, " "));
                }
            };
            CommonASTWithHiddenTokens publicNode = new CommonASTWithHiddenTokens((Token)publicToken);
            publicNode.setNextSibling(oldFirstMod);
            mods.setFirstChild((AST)publicNode);
        } else {
            AST kid = node.getFirstChild();
            while (kid != null) {
                this.makeSimpleMethodsPublic(kid);
                kid = kid.getNextSibling();
            }
        }
    }

    protected void writeParseTree(String filename, AST ast) {
        try {
            PrintStream stream = new PrintStream(new FileOutputStream(filename));
            stream.println("<?xml version=\"1.0\"?>");
            stream.println("<document>");
            OutputStreamWriter writer = new OutputStreamWriter(stream);
            if (ast != null) {
                ((CommonAST)ast).xmlSerialize((Writer)writer);
            }
            writer.flush();
            stream.println("</document>");
            writer.close();
        }
        catch (IOException iOException) {}
    }

    protected int writeImports(PrintWriter out, List<String> programImports, List<String> codeFolderImports) {
        int count = this.writeImportList(out, this.getCoreImports());
        count += this.writeImportList(out, programImports);
        count += this.writeImportList(out, codeFolderImports);
        return count += this.writeImportList(out, this.getDefaultImports());
    }

    protected int writeImportList(PrintWriter out, List<String> imports) {
        return this.writeImportList(out, imports.toArray(new String[0]));
    }

    protected int writeImportList(PrintWriter out, String[] imports) {
        int count = 0;
        if (imports != null && imports.length != 0) {
            String[] stringArray = imports;
            int n = imports.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                out.println("import " + item + "; ");
                ++count;
                ++n2;
            }
            out.println();
            ++count;
        }
        return count;
    }

    protected void writeDeclaration(PrintWriter out, String className) {
        if (this.mode == Mode.JAVA) {
            out.println();
            out.println();
        } else if (this.mode == Mode.ACTIVE) {
            out.println("public class " + className + " extends PApplet {");
            out.println();
        } else if (this.mode == Mode.STATIC) {
            out.println("public class " + className + " extends PApplet {");
            out.println(String.valueOf(this.indent) + "public void setup() {");
        }
    }

    protected void writeFooter(PrintWriter out, String className) {
        if (this.mode == Mode.STATIC) {
            out.println(String.valueOf(this.indent) + this.indent + "noLoop();");
            out.println(String.valueOf(this.indent) + "}");
            out.println();
        }
        if (this.mode == Mode.STATIC || this.mode == Mode.ACTIVE) {
            if (this.sketchWidth != null && !this.hasMethod("sketchWidth") && (PApplet.parseInt((String)this.sketchWidth, (int)-1) != -1 || this.sketchWidth.equals("displayWidth"))) {
                out.println(String.valueOf(this.indent) + "public int sketchWidth() { return " + this.sketchWidth + "; }");
            }
            if (this.sketchHeight != null && !this.hasMethod("sketchHeight") && (PApplet.parseInt((String)this.sketchHeight, (int)-1) != -1 || this.sketchHeight.equals("displayHeight"))) {
                out.println(String.valueOf(this.indent) + "public int sketchHeight() { return " + this.sketchHeight + "; }");
            }
            if (this.sketchRenderer != null && !this.hasMethod("sketchRenderer") && (this.sketchRenderer.equals("P2D") || this.sketchRenderer.equals("P3D") || this.sketchRenderer.equals("OPENGL") || this.sketchRenderer.equals("JAVA2D"))) {
                out.println(String.valueOf(this.indent) + "public String sketchRenderer() { return " + this.sketchRenderer + "; }");
            }
            if (!this.hasMethod("main")) {
                out.println(String.valueOf(this.indent) + "static public void main(String[] passedArgs) {");
                out.print(String.valueOf(this.indent) + this.indent + "String[] appletArgs = new String[] { ");
                if (Preferences.getBoolean("export.application.fullscreen")) {
                    out.print("\"--full-screen\", ");
                    String farbe = Preferences.get("run.present.bgcolor");
                    out.print("\"--bgcolor=" + farbe + "\", ");
                    if (Preferences.getBoolean("export.application.stop")) {
                        farbe = Preferences.get("run.present.stop.color");
                        out.print("\"--stop-color=" + farbe + "\", ");
                    } else {
                        out.print("\"--hide-stop\", ");
                    }
                }
                out.println("\"" + className + "\" };");
                out.println(String.valueOf(this.indent) + this.indent + "if (passedArgs != null) {");
                out.println(String.valueOf(this.indent) + this.indent + "  PApplet.main(concat(appletArgs, passedArgs));");
                out.println(String.valueOf(this.indent) + this.indent + "} else {");
                out.println(String.valueOf(this.indent) + this.indent + "  PApplet.main(appletArgs);");
                out.println(String.valueOf(this.indent) + this.indent + "}");
                out.println(String.valueOf(this.indent) + "}");
            }
            out.println("}");
        }
    }

    public String[] getCoreImports() {
        return new String[]{"processing.core.*", "processing.data.*", "processing.event.*", "processing.opengl.*"};
    }

    public String[] getDefaultImports() {
        return new String[]{"java.util.HashMap", "java.util.ArrayList", "java.io.File", "java.io.BufferedReader", "java.io.PrintWriter", "java.io.InputStream", "java.io.OutputStream", "java.io.IOException"};
    }

    public boolean ignoreImport(String pkg) {
        return false;
    }

    String getFirstClassName(AST ast) {
        String t = this.advClassName;
        this.advClassName = "";
        return t;
    }

    public void debugAST(AST ast, boolean includeHidden) {
        System.err.println("------------------");
        this.debugAST(ast, includeHidden, 0);
    }

    private void debugAST(AST ast, boolean includeHidden, int indent) {
        int i = 0;
        while (i < indent) {
            System.err.print("    ");
            ++i;
        }
        if (includeHidden) {
            System.err.print(this.debugHiddenBefore(ast));
        }
        if (ast.getType() > 0 && !ast.getText().equals(TokenUtil.nameOf(ast))) {
            System.err.print(String.valueOf(TokenUtil.nameOf(ast)) + "/");
        }
        System.err.print(ast.getText().replace("\n", "\\n"));
        if (includeHidden) {
            System.err.print(this.debugHiddenAfter(ast));
        }
        System.err.println();
        AST kid = ast.getFirstChild();
        while (kid != null) {
            this.debugAST(kid, includeHidden, indent + 1);
            kid = kid.getNextSibling();
        }
    }

    private String debugHiddenAfter(AST ast) {
        if (!(ast instanceof CommonASTWithHiddenTokens)) {
            return "";
        }
        return this.debugHiddenTokens(((CommonASTWithHiddenTokens)ast).getHiddenAfter());
    }

    private String debugHiddenBefore(AST ast) {
        if (!(ast instanceof CommonASTWithHiddenTokens)) {
            return "";
        }
        CommonHiddenStreamToken child = null;
        CommonHiddenStreamToken parent = ((CommonASTWithHiddenTokens)ast).getHiddenBefore();
        if (parent == null) {
            return "";
        }
        while ((parent = (child = parent).getHiddenBefore()) != null) {
        }
        return this.debugHiddenTokens(child);
    }

    private String debugHiddenTokens(CommonHiddenStreamToken t) {
        StringBuilder sb = new StringBuilder();
        while (t != null) {
            if (sb.length() == 0) {
                sb.append("[");
            }
            sb.append(t.getText().replace("\n", "\\n"));
            t = this.filter.getHiddenAfter(t);
        }
        if (sb.length() > 0) {
            sb.append("]");
        }
        return sb.toString();
    }

    public static enum Mode {
        STATIC,
        ACTIVE,
        JAVA;

    }
}

