/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.runner;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ExceptionRequest;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdi.Bootstrap;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Library;
import processing.app.Preferences;
import processing.app.RunnerListener;
import processing.app.SketchException;
import processing.app.exec.StreamRedirectThread;
import processing.core.PApplet;
import processing.mode.java.JavaBuild;
import processing.mode.java.runner.MessageConsumer;
import processing.mode.java.runner.MessageSiphon;

public class Runner
implements MessageConsumer {
    protected RunnerListener listener;
    protected VirtualMachine vm;
    protected Thread errThread = null;
    protected Thread outThread = null;
    protected SketchException exception;
    protected Editor editor;
    protected JavaBuild build;
    protected Process process;

    public Runner(JavaBuild build, RunnerListener listener) throws SketchException {
        this.listener = listener;
        this.build = build;
        if (listener instanceof Editor) {
            this.editor = (Editor)listener;
        }
        int bits = Base.getNativeBits();
        for (Library library : build.getImportedLibraries()) {
            int opposite;
            if (library.supportsArch(PApplet.platform, bits)) continue;
            System.err.println(String.valueOf(library.getName()) + " does not run in " + bits + "-bit mode.");
            int n = opposite = bits == 32 ? 64 : 32;
            if (Base.isMacOS()) {
                throw new SketchException("To use " + library.getName() + ", " + "switch to " + opposite + "-bit mode in Preferences.");
            }
            throw new SketchException(String.valueOf(library.getName()) + " is only compatible " + "with the  " + opposite + "-bit download of Processing.");
        }
    }

    public void launch(boolean presenting) {
        if (this.launchVirtualMachine(presenting)) {
            this.generateTrace();
        }
    }

    public boolean launchVirtualMachine(boolean presenting) {
        String[] vmParams = this.getMachineParams();
        String[] sketchParams = this.getSketchParams(presenting);
        int port = 8000 + (int)(Math.random() * 1000.0);
        String portStr = String.valueOf(port);
        String jdwpArg = "-agentlib:jdwp=transport=dt_socket,address=" + portStr + ",server=y,suspend=y";
        String[] commandArgs = new String[]{Base.getJavaPath(), jdwpArg};
        commandArgs = PApplet.concat((String[])commandArgs, (String[])vmParams);
        commandArgs = PApplet.concat((String[])commandArgs, (String[])sketchParams);
        this.launchJava(commandArgs);
        AttachingConnector connector = (AttachingConnector)this.findConnector("com.sun.jdi.SocketAttach");
        Map<String, Connector.Argument> arguments = connector.defaultArguments();
        Connector.Argument portArg = arguments.get("port");
        portArg.setValue(portStr);
        while (true) {
            try {
                do {
                    this.vm = connector.attach(arguments);
                } while (this.vm == null);
                return true;
            }
            catch (IOException iOException) {
                try {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                catch (IllegalConnectorArgumentsException exc) {
                    throw new Error("Internal error: " + exc);
                }
            }
            break;
        }
    }

    protected String[] getMachineParams() {
        ArrayList<String> params = new ArrayList<String>();
        String options = Preferences.get("run.options");
        if (options.length() > 0) {
            String[] pieces = PApplet.split((String)options, (char)' ');
            int i = 0;
            while (i < pieces.length) {
                String p = pieces[i].trim();
                if (p.length() > 0) {
                    params.add(p);
                }
                ++i;
            }
        }
        if (Preferences.getBoolean("run.options.memory")) {
            params.add("-Xms" + Preferences.get("run.options.memory.initial") + "m");
            params.add("-Xmx" + Preferences.get("run.options.memory.maximum") + "m");
        }
        if (Base.isMacOS()) {
            params.add("-Xdock:name=" + this.build.getSketchClassName());
        }
        params.add("-Djava.library.path=" + this.build.getJavaLibraryPath() + File.pathSeparator + System.getProperty("java.library.path"));
        params.add("-cp");
        params.add(this.build.getClassPath());
        params.add("-ea");
        String[] outgoing = new String[params.size()];
        params.toArray(outgoing);
        return outgoing;
    }

    protected String[] getSketchParams(boolean presenting) {
        ArrayList<String> params = new ArrayList<String>();
        if (this.build.getFoundMain()) {
            params.add(this.build.getSketchClassName());
        } else {
            params.add("processing.core.PApplet");
            int runDisplay = Preferences.getInteger("run.display");
            if (this.editor != null) {
                GraphicsDevice editorDevice = this.editor.getGraphicsConfiguration().getDevice();
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice[] devices = ge.getScreenDevices();
                GraphicsDevice runDevice = editorDevice;
                if (runDisplay >= 0 && runDisplay < devices.length) {
                    runDevice = devices[runDisplay];
                } else {
                    runDevice = editorDevice;
                    int i = 0;
                    while (i < devices.length) {
                        if (devices[i] == runDevice) {
                            runDisplay = i;
                            break;
                        }
                        ++i;
                    }
                }
                Point windowLocation = this.editor.getSketchLocation();
                if (windowLocation == null) {
                    if (editorDevice == runDevice) {
                        Point editorLocation = this.editor.getLocation();
                        params.add("--editor-location=" + editorLocation.x + "," + editorLocation.y);
                    }
                } else {
                    params.add("--location=" + windowLocation.x + "," + windowLocation.y);
                }
                params.add("--external");
            }
            params.add("--display=" + runDisplay);
            if (presenting) {
                params.add("--full-screen");
                params.add("--stop-color=" + Preferences.get("run.present.stop.color"));
                params.add("--bgcolor=" + Preferences.get("run.present.bgcolor"));
            }
            params.add(this.build.getSketchClassName());
            params.add("--sketch-path=" + this.build.getSketchPath());
        }
        return params.toArray(new String[0]);
    }

    protected void launchJava(final String[] args) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runner.this.process = PApplet.exec((String[])args);
                try {
                    int result = Runner.this.process.waitFor();
                    if (result != 0) {
                        String[] errorStrings = PApplet.loadStrings((InputStream)Runner.this.process.getErrorStream());
                        String[] inputStrings = PApplet.loadStrings((InputStream)Runner.this.process.getInputStream());
                        PApplet.printArray((Object)inputStrings);
                        if (errorStrings != null && errorStrings.length > 1) {
                            if (errorStrings[0].indexOf("Invalid maximum heap size") != -1) {
                                Base.showWarning("Way Too High", "Please lower the value for \u201cmaximum available memory\u201d in the\nPreferences window. For more information, read Help \u2192 Troubleshooting.", null);
                            } else {
                                String[] stringArray = errorStrings;
                                int n = errorStrings.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String err = stringArray[n2];
                                    System.err.println(err);
                                    ++n2;
                                }
                                System.err.println("Using startup command: " + PApplet.join((String[])args, (String)" "));
                            }
                        } else {
                            System.err.println("Could not run the sketch (Target VM failed to initialize).");
                            if (Preferences.getBoolean("run.options.memory")) {
                                System.err.println("Make sure that you haven't set the maximum available memory too high.");
                            }
                            System.err.println("For more information, read revisions.txt and Help \u2192 Troubleshooting.");
                        }
                        Runner.this.listener.statusError("Could not run the sketch.");
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    protected void generateTrace() {
        PrintWriter writer = null;
        this.vm.allThreads();
        EventRequestManager mgr = this.vm.eventRequestManager();
        ExceptionRequest excReq = mgr.createExceptionRequest(null, false, true);
        excReq.setSuspendPolicy(2);
        excReq.enable();
        Thread eventThread = new Thread(){

            @Override
            public void run() {
                try {
                    boolean connected = true;
                    while (connected) {
                        EventQueue eventQueue = Runner.this.vm.eventQueue();
                        EventSet eventSet = eventQueue.remove();
                        for (Event event : eventSet) {
                            if (event instanceof VMStartEvent) {
                                Runner.this.vm.resume();
                                continue;
                            }
                            if (event instanceof ExceptionEvent) {
                                Runner.this.exceptionEvent((ExceptionEvent)event);
                                continue;
                            }
                            if (!(event instanceof VMDisconnectEvent)) continue;
                            connected = false;
                        }
                    }
                }
                catch (Exception e) {
                    System.err.println("crashed in event thread due to " + e.getMessage());
                    e.printStackTrace();
                }
            }
        };
        eventThread.start();
        this.errThread = new MessageSiphon(this.process.getErrorStream(), this).getThread();
        this.outThread = new StreamRedirectThread("JVM stdout Reader", this.process.getInputStream(), System.out);
        this.errThread.start();
        this.outThread.start();
        try {
            if (eventThread != null) {
                eventThread.join();
            }
            this.errThread.join();
            this.outThread.join();
            if (this.editor != null) {
                this.editor.deactivateRun();
            }
        }
        catch (InterruptedException interruptedException) {}
        if (writer != null) {
            writer.close();
        }
    }

    protected Connector findConnector(String connectorName) {
        List<Connector> connectors = Bootstrap.virtualMachineManager().allConnectors();
        for (Connector c : connectors) {
            Connector connector = c;
            if (!connector.name().equals(connectorName)) continue;
            return connector;
        }
        Base.showError("Compiler Error", "findConnector() failed to find " + connectorName + " inside Runner", null);
        return null;
    }

    public void exceptionEvent(ExceptionEvent event) {
        ObjectReference or = event.exception();
        ReferenceType rt = or.referenceType();
        String exceptionName = rt.name();
        Field messageField = rt.fieldByName("detailMessage");
        Value messageValue = or.getValue(messageField);
        int last = exceptionName.lastIndexOf(46);
        String message = exceptionName.substring(last + 1);
        if (messageValue != null) {
            String messageStr = messageValue.toString();
            if (messageStr.startsWith("\"")) {
                messageStr = messageStr.substring(1, messageStr.length() - 1);
            }
            message = String.valueOf(message) + ": " + messageStr;
        }
        this.reportException(message, or, event.thread());
        Runner.handleCommonErrors(exceptionName, message, this.listener);
        if (this.editor != null) {
            this.editor.deactivateRun();
        }
    }

    public static boolean handleCommonErrors(String exceptionClass, String message, RunnerListener listener) {
        if (exceptionClass.equals("java.lang.OutOfMemoryError")) {
            if (message.contains("exceeds VM budget")) {
                listener.statusError("OutOfMemoryError: This code attempts to use more memory than available.");
                System.err.println("An OutOfMemoryError means that your code is either using up too much memory");
                System.err.println("because of a bug (e.g. creating an array that's too large, or unintentionally");
                System.err.println("loading thousands of images), or simply that it's trying to use more memory");
                System.err.println("than what is supported by the current device.");
            } else {
                listener.statusError("OutOfMemoryError: You may need to increase the memory setting in Preferences.");
                System.err.println("An OutOfMemoryError means that your code is either using up too much memory");
                System.err.println("because of a bug (e.g. creating an array that's too large, or unintentionally");
                System.err.println("loading thousands of images), or that your sketch may need more memory to run.");
                System.err.println("If your sketch uses a lot of memory (for instance if it loads a lot of data files)");
                System.err.println("you can increase the memory available to your sketch using the Preferences window.");
            }
        } else if (exceptionClass.equals("java.lang.UnsatisfiedLinkError")) {
            listener.statusError("A library used by this sketch is not installed properly.");
            System.err.println("A library relies on native code that's not available.");
            System.err.println("Or only works properly when the sketch is run as a " + (Base.getNativeBits() == 32 ? "64-bit " : "32-bit ") + " application.");
        } else if (exceptionClass.equals("java.lang.StackOverflowError")) {
            listener.statusError("StackOverflowError: This sketch is attempting too much recursion.");
            System.err.println("A StackOverflowError means that you have a bug that's causing a function");
            System.err.println("to be called recursively (it's calling itself and going in circles),");
            System.err.println("or you're intentionally calling a recursive function too much,");
            System.err.println("and your code should be rewritten in a more efficient manner.");
        } else if (exceptionClass.equals("java.lang.UnsupportedClassVersionError")) {
            listener.statusError("UnsupportedClassVersionError: A library is using code compiled with an unsupported version of Java.");
            System.err.println("This version of Processing only supports libraries and JAR files compiled for Java 1.6 or earlier.");
            System.err.println("A library used by this sketch was compiled for Java 1.7 or later, ");
            System.err.println("and needs to be recompiled to be compatible with Java 1.6.");
        } else if (exceptionClass.equals("java.lang.NoSuchMethodError") || exceptionClass.equals("java.lang.NoSuchFieldError")) {
            listener.statusError(String.valueOf(exceptionClass.substring(10)) + ": " + "You may be using a library that's incompatible " + "with this version of Processing.");
        } else {
            return false;
        }
        return true;
    }

    protected void reportException(String message, ObjectReference or, ThreadReference thread) {
        this.listener.statusError(this.findException(message, or, thread));
    }

    protected SketchException findException(String message, ObjectReference or, ThreadReference thread) {
        try {
            List<StackFrame> frames = thread.frames();
            for (StackFrame frame : frames) {
                try {
                    Location location = frame.location();
                    String filename = null;
                    filename = location.sourceName();
                    int lineNumber = location.lineNumber() - 1;
                    SketchException rex = this.build.placeException(message, filename, lineNumber);
                    if (rex == null) continue;
                    return rex;
                }
                catch (AbsentInformationException absentInformationException) {
                    this.exception = new SketchException(message);
                    this.exception.hideStackTrace();
                    this.listener.statusError(this.exception);
                }
            }
        }
        catch (IncompatibleThreadStateException e) {
            e.printStackTrace();
        }
        try {
            Method method = ((ClassType)or.referenceType()).concreteMethodByName("getStackTrace", "()[Ljava/lang/StackTraceElement;");
            ArrayReference result = (ArrayReference)or.invokeMethod(thread, method, new ArrayList(), 1);
            for (Value val : result.getValues()) {
                IntegerValue intval;
                int lineNumber;
                ObjectReference ref = (ObjectReference)val;
                StringReference strref = (StringReference)ref.invokeMethod(thread, method = ((ClassType)ref.referenceType()).concreteMethodByName("getFileName", "()Ljava/lang/String;"), new ArrayList(), 1);
                String filename = strref == null ? "Unknown Source" : strref.value();
                SketchException rex = this.build.placeException(message, filename, lineNumber = (intval = (IntegerValue)ref.invokeMethod(thread, method = ((ClassType)ref.referenceType()).concreteMethodByName("getLineNumber", "()I"), new ArrayList(), 1)).intValue() - 1);
                if (rex == null) continue;
                return rex;
            }
            method = ((ClassType)or.referenceType()).concreteMethodByName("printStackTrace", "()V");
            or.invokeMethod(thread, method, new ArrayList(), 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SketchException rex = new SketchException(message);
        rex.hideStackTrace();
        return rex;
    }

    public void close() {
        if (this.vm != null) {
            try {
                this.vm.exit(0);
            }
            catch (VMDisconnectedException vMDisconnectedException) {}
            this.vm = null;
        }
    }

    @Override
    public synchronized void message(String s) {
        if (s.indexOf("__STOP__") == 0) {
            if (this.editor != null) {
                this.editor.internalCloseRunner();
            }
            return;
        }
        if (s.indexOf("__MOVE__") == 0) {
            String nums = s.substring(s.indexOf(32) + 1).trim();
            int space = nums.indexOf(32);
            int left = Integer.parseInt(nums.substring(0, space));
            int top = Integer.parseInt(nums.substring(space + 1));
            this.editor.setSketchLocation(new Point(left, top));
            return;
        }
        System.err.print(s);
        System.err.flush();
    }
}

