
attribute vec2 aV;
attribute vec2 aUV0;

uniform vec3 u_matrix2D[2];

uniform float u_kernelScale;

varying vec2 vUV0;
varying vec2 vUV1;
varying vec2 vUV2;
varying vec2 vUV3;
varying vec2 vUV4;
varying vec2 vUV5;
varying vec2 vUV6;

const float BLUR_FILTER_SIZE = 0.003;

const float COS_30 = 0.866025404;
const float SIN_30 = 0.5;

void main(void)
{
   vec2 P;
   P.x = dot(u_matrix2D[0], vec3(aV, 1.0));
   P.y = dot(u_matrix2D[1], vec3(aV, 1.0));

   gl_Position = vec4(P, 0.0, 1.0);

   vec2 uv = aUV0;

   vUV0 = uv;
   vUV1 = uv + vec2(0.0, BLUR_FILTER_SIZE * u_kernelScale);
   vUV2 = uv + vec2(0.0, -BLUR_FILTER_SIZE * u_kernelScale);
   vUV3 = uv + vec2(COS_30 * BLUR_FILTER_SIZE * u_kernelScale, SIN_30 * BLUR_FILTER_SIZE * u_kernelScale);
   vUV4 = uv + vec2(-COS_30 * BLUR_FILTER_SIZE * u_kernelScale, SIN_30 * BLUR_FILTER_SIZE * u_kernelScale);
   vUV5 = uv + vec2(COS_30 * BLUR_FILTER_SIZE * u_kernelScale, -SIN_30 * BLUR_FILTER_SIZE * u_kernelScale);
   vUV6 = uv + vec2(-COS_30 * BLUR_FILTER_SIZE * u_kernelScale, -SIN_30 * BLUR_FILTER_SIZE * u_kernelScale);
}
