
attribute vec2 aV;
attribute vec2 aUV0;

uniform vec3 u_matrix2D[2];

uniform vec2 u_screenSize;

varying vec2 vUV0;
varying vec2 vUV1;
varying vec2 vUV2;
varying vec2 vUV3;
varying vec2 vUV4;
varying vec2 vUV5;
varying vec2 vUV6;

const float BLUR_FILTER_SIZE = 0.006;

void main(void)
{
   vec2 P;
   P.x = dot(u_matrix2D[0], vec3(aV, 1.0));
   P.y = dot(u_matrix2D[1], vec3(aV, 1.0));

   gl_Position = vec4(P, 0.0, 1.0);

   vec2 uv = aUV0;

   float size = BLUR_FILTER_SIZE * (u_screenSize.x / u_screenSize.y);

   vUV0 = uv;
   vUV1 = uv + vec2(0.0, size);
   vUV2 = uv + vec2(0.0, -size);
   vUV3 = uv + vec2(0.0, size * 2.0);
   vUV4 = uv + vec2(0.0, -size * 2.0);
   vUV5 = uv + vec2(0.0, size * 3.0);
   vUV6 = uv + vec2(0.0, -size * 3.0);
}
