
uniform float u_dissolveAnim;

attribute vec4 aV;
attribute vec4 aSA;
attribute vec4 aSB;
attribute vec4 aSC;

varying vec2 vUV;
varying vec3 vE;
varying vec3 vL0;
varying float vL0I;
varying vec3 vL1;
varying float vDissolve;

#ifdef GL_ES
#else
varying float vMarker;
#endif

void main(void)
{
   float ld = 1.0 - length((vec3(0.0, 0.0, 3.0) - aV.xyz)) * 0.2;
   vDissolve =  u_dissolveAnim * 4.0 - ld * 3.0;

   vec4 vertexPos = vec4(aV.x, aV.y, aV.z, 1.0);
   vec3 vertexNormal = vec3(aV.w, aSA.x, aSA.y);
   vec3 vertexTangent = vec3(aSA.z, aSA.w, aSB.x);
   vUV = aSB.zw;

   int bi0 = int(aSC.w);
   int bi2 = bi0 / 1024;
   bi0 -= bi2 * 1024;
   int bi1 = bi0 / 32;
   bi0 -= bi1 * 32;

   vec4 bvx = u_boneMatrices[bi0 * 3    ] * aSC.x;
   vec4 bvy = u_boneMatrices[bi0 * 3 + 1] * aSC.x;
   vec4 bvz = u_boneMatrices[bi0 * 3 + 2] * aSC.x;

   bvx += u_boneMatrices[bi1 * 3    ] * aSC.y;
   bvy += u_boneMatrices[bi1 * 3 + 1] * aSC.y;
   bvz += u_boneMatrices[bi1 * 3 + 2] * aSC.y;

   bvx += u_boneMatrices[bi2 * 3    ] * aSC.z;
   bvy += u_boneMatrices[bi2 * 3 + 1] * aSC.z;
   bvz += u_boneMatrices[bi2 * 3 + 2] * aSC.z;

   vec4 localP;
   vec3 localN;
   vec3 localT;

   localP.x = dot(bvx, vertexPos);
   localN.x = dot(bvx.xyz, vertexNormal);
   localT.x = dot(bvx.xyz, vertexTangent);

   localP.y = dot(bvy, vertexPos);
   localP.z = dot(bvz, vertexPos);
   localP.w = 1.0;

   localN.y = dot(bvy.xyz, vertexNormal);
   localN.z = dot(bvz.xyz, vertexNormal);

   localT.y = dot(bvy.xyz, vertexTangent);
   localT.z = dot(bvz.xyz, vertexTangent);

   vec3 E;
   E.x = dot(u_modelViewMatrix[0], localP);
   E.y = dot(u_modelViewMatrix[1], localP);
   E.z = dot(u_modelViewMatrix[2], localP);

   vec3 N;
   N.x = dot(u_normalModelViewMatrix[0], localN);
   N.y = dot(u_normalModelViewMatrix[1], localN);
   N.z = dot(u_normalModelViewMatrix[2], localN);

   float normMul = 1.0 / length(N);
   N *= normMul;

   vec3 T;
   T.x = dot(u_normalModelViewMatrix[0], localT);
   T.y = dot(u_normalModelViewMatrix[1], localT);
   T.z = dot(u_normalModelViewMatrix[2], localT);
   T *= normMul;

   vec3 B = calculateBinormal(N, T, aSB.y);

   vE = normalize(transformViewVectorToTangent(E, T, B, N));

   vec3 L0 = u_omniLight0.xyz - E;
   float L0_distance = length(L0);

   vL0 = transformViewVectorToTangent(L0, T, B, N) / L0_distance;
   vL0I = calculateLight0Intensity(L0_distance);

   vL1 = transformViewVectorToTangent(calculateNormalizedDeltaVector(E, u_omniLight1.xyz), T, B, N);

#ifdef GL_ES
#else
   if (vUV.x < 0.0)
   {
      vUV.x = -vUV.x;
      vMarker = 1.0;
   }
   else
   {
      vMarker = 0.0;
   }
#endif

   gl_Position = transformLocalPointToScreen(localP);
}
