
uniform sampler2D tA;
uniform sampler2D tE;

uniform bool u_dissolveEnabled;

#ifdef GL_ES

varying highp vec2 vUV;
varying lowp vec3 vL;
varying lowp float vDissolve;

#else

varying vec2 vUV;
varying vec3 vL;
varying float vDissolve;

#endif

void main(void)
{
#ifdef GL_ES
   lowp vec3 C;
   lowp float E;
#else
   vec3 C;
   float E;
#endif

   if (u_dissolveEnabled)
   {
      if (vDissolve > 1.0)
      {
         discard;
      }
      else
      {
		   C = texture2D(tA, vUV).rgb;
		   E = texture2D(tE, vUV).r;

		   gl_FragColor.rgb = C * vL + u_color.rgb * E;
		}
	}
	else
	{
	   C = texture2D(tA, vUV).rgb;
	   E = texture2D(tE, vUV).r;

	   gl_FragColor.rgb = C * vL + u_color.rgb * E;	
	}
}
