
uniform float u_dissolveAnim;

attribute vec4 aV;
attribute vec4 aSA;
attribute vec4 aSB;
attribute vec4 aSC;

varying vec2 vUV;
varying vec3 vL;
varying float vDissolve;

#ifdef GL_ES
#else
varying float vMarker;
#endif

void main(void)
{
   float ld = 1.0 - length((vec3(0.0, 0.0, 3.0) - aV.xyz)) * 0.2;
   vDissolve =  u_dissolveAnim * 4.0 - ld * 3.0;

   vec4 vertexPos = vec4(aV.x, aV.y, aV.z, 1.0);
   vec3 vertexNormal = vec3(aV.w, aSA.x, aSA.y);
   vUV = aSB.zw;

   int bi0 = int(aSC.w);
   int bi2 = bi0 / 1024;
   bi0 -= bi2 * 1024;
   int bi1 = bi0 / 32;
   bi0 -= bi1 * 32;

   vec4 bvx = u_boneMatrices[bi0 * 3    ] * aSC.x;
   vec4 bvy = u_boneMatrices[bi0 * 3 + 1] * aSC.x;
   vec4 bvz = u_boneMatrices[bi0 * 3 + 2] * aSC.x;

   bvx += u_boneMatrices[bi1 * 3    ] * aSC.y;
   bvy += u_boneMatrices[bi1 * 3 + 1] * aSC.y;
   bvz += u_boneMatrices[bi1 * 3 + 2] * aSC.y;

   bvx += u_boneMatrices[bi2 * 3    ] * aSC.z;
   bvy += u_boneMatrices[bi2 * 3 + 1] * aSC.z;
   bvz += u_boneMatrices[bi2 * 3 + 2] * aSC.z;

   vec4 localP = transformPosePointToLocal(vertexPos, bvx, bvy, bvz);
   vec3 localN = transformPoseVectorToLocal(vertexNormal, bvx, bvy, bvz);

   vec3 E = transformLocalPointToView(localP);
   vec3 N = normalize(transformLocalVectorToView(localN));

   vL = u_skyColor + calculateLight0DiffusionAtViewPoint(E, N) + calculateLight1DiffusionAtViewPoint(E, N);

#ifdef GL_ES
#else
   if (vUV.x < 0.0)
   {
      vUV.x = -vUV.x;
      vMarker = 1.0;
   }
   else
   {
      vMarker = 0.0;
   }
#endif

   gl_Position = transformLocalPointToScreen(localP);
}
