
uniform sampler2D tA;
uniform sampler2D tN;
uniform sampler2D tS;
uniform sampler2D tE;

uniform bool u_colorize;

#ifdef GL_ES

uniform lowp vec3 u_skyColor;

uniform lowp vec3 u_omniLightColor0;
uniform lowp vec3 u_omniLightColor1;

uniform lowp float u_colorizeT;
uniform lowp vec3 u_colorizeColor;
uniform lowp float u_characterDimming;

varying highp vec2 vUV;
varying lowp vec3 vE;
varying lowp vec3 vL0;
varying lowp float vL0I;
varying lowp vec3 vL1;

varying lowp float vDissolve;

#else

uniform vec3 u_skyColor;

uniform vec3 u_omniLightColor0;
uniform vec3 u_omniLightColor1;

uniform float u_colorizeT;
uniform vec3 u_colorizeColor;
uniform float u_characterDimming;

varying vec2 vUV;
varying vec3 vE;
varying vec3 vL0;
varying float vL0I;
varying vec3 vL1;

varying float vDissolve;

#endif

void main(void)
{
#ifdef GL_ES

   lowp vec3 C;
   lowp vec3 N;
   lowp float SI;
   lowp float E;
   lowp float L0D;
   lowp float L0S;
   lowp float L1D;

#else

   vec3 C;
   vec3 N;
   float SI;
   float E;
   float L0D;
   float L0S;
   float L1D;

#endif

   if (vDissolve > 1.0)
   {
      discard;
   }
   else
   {
      C = texture2D(tA, vUV).rgb;
      N = normalize(texture2D(tN, vUV).xyz * 2.0 - vec3(1.0));
      SI = texture2D(tS, vUV).r;
      E = texture2D(tE, vUV).r;

      L0D = max(dot(N, vL0), 0.0) * vL0I;

#ifdef GL_ES
      L0S = max(dot(reflect(vL0, N), vE), 0.0);
#else
      L0S = max(dot(reflect(vL0, N), vE) * max(-sign(dot(N, vE)), 0.0) * max(sign(dot(N, vL0)), 0.0), 0.0);
#endif

      L0S *= L0S;
      L0S *= L0S;
      L0S *= vL0I;
      L0S *= SI;
      L0S *= u_characterDimming;

      L1D = max(dot(N, vL1), 0.0);

      C = (C * ((u_omniLightColor0 * L0D) + (u_omniLightColor1 * L1D) + u_skyColor * 2.0) * u_characterDimming + u_omniLightColor0 * L0S) + vec3(0.15, 0.85, 1.0) * E;

      if (u_colorize)
      {
         gl_FragColor.rgb = mix(C, ((C - vec3(0.3)) * 2.0 + vec3(0.3)) + u_colorizeColor, u_colorizeT);
      }
      else
      {
         gl_FragColor.rgb = C;
      }
   }
}
