
uniform sampler2D tA;
uniform sampler2D tE;

uniform bool u_colorize;

#ifdef GL_ES

uniform lowp vec3 u_fogColor;

uniform lowp float u_colorizeT;
uniform lowp vec3 u_colorizeColor;
uniform lowp float u_characterDimming;

varying highp vec2 vUV;
varying lowp vec3 vL;
varying lowp float vDissolve;

#else

uniform vec3 u_fogColor;

uniform float u_colorizeT;
uniform vec3 u_colorizeColor;
uniform float u_characterDimming;

varying vec2 vUV;
varying vec3 vL;
varying float vDissolve;

#endif

void main(void)
{
#ifdef GL_ES
   lowp vec3 C;
   lowp float E;
#else
   vec3 C;
   float E;
#endif

   if (vDissolve > 1.0)
   {
      discard;
   }
   else
   {
      E = texture2D(tE, vUV).r;
      C = texture2D(tA, vUV).rgb * (vL * u_characterDimming) + vec3(0.15, 0.85, 1.0) * E;

      if (u_colorize)
      {
         gl_FragColor.rgb = mix(C, ((C - vec3(0.3)) * 2.0 + vec3(0.3)) + u_colorizeColor, u_colorizeT);
      }
      else
      {
         gl_FragColor.rgb = C;
      }
   }
}
