
attribute vec4 aV;
attribute vec4 aSA;
attribute vec4 aSB;
attribute vec4 aSC;

uniform vec3 u_skyColor;
uniform vec2 u_layerFogParams;

uniform vec4 u_boneMatrices[96];
uniform mat4 u_mvpMatrix;
uniform vec4 u_modelViewMatrix[3];
uniform vec3 u_normalModelViewMatrix[3];
uniform vec4 u_modelMatrix[3];

uniform vec4 u_omniLight0; // pos_x, pos_y, pos_z, decay_distance
uniform vec4 u_omniLight1; // pos_x, pos_y, pos_z, decay_distance

uniform vec3 u_omniLightColor0;
uniform vec3 u_omniLightColor1;

varying vec2 vUV;

uniform float u_dissolveAnim;

varying vec3 vL;
varying float vDissolve;

void main(void)
{
   float ld = length((vec3(0.0, 0.15, -0.35) - aV.xyz) * vec3(0.9, 1.0, 0.7));
   vDissolve = max(1.0 - ld * 8.0 + u_dissolveAnim * 7.8, 0.0);

   vec4 vertexPos = vec4(aV.x, aV.y, aV.z, 1.0);
   vec3 vertexNormal = vec3(aV.w, aSA.x, aSA.y);
   vUV = aSB.zw;

   int bi0 = int(aSC.w);
   int bi2 = bi0 / 1024;
   bi0 -= bi2 * 1024;
   int bi1 = bi0 / 32;
   bi0 -= bi1 * 32;

   vec4 bvx = u_boneMatrices[bi0 * 3    ] * aSC.x;
   vec4 bvy = u_boneMatrices[bi0 * 3 + 1] * aSC.x;
   vec4 bvz = u_boneMatrices[bi0 * 3 + 2] * aSC.x;

   bvx += u_boneMatrices[bi1 * 3    ] * aSC.y;
   bvy += u_boneMatrices[bi1 * 3 + 1] * aSC.y;
   bvz += u_boneMatrices[bi1 * 3 + 2] * aSC.y;

   bvx += u_boneMatrices[bi2 * 3    ] * aSC.z;
   bvy += u_boneMatrices[bi2 * 3 + 1] * aSC.z;
   bvz += u_boneMatrices[bi2 * 3 + 2] * aSC.z;

   vec4 localP;
   vec3 localN;

   localP.x = dot(bvx, vertexPos);
   localN.x = dot(bvx.xyz, vertexNormal);

   localP.y = dot(bvy, vertexPos);
   localP.z = dot(bvz, vertexPos);
   localP.w = 1.0;

   localN.y = dot(bvy.xyz, vertexNormal);
   localN.z = dot(bvz.xyz, vertexNormal);

   vec3 E;
   E.x = dot(u_modelViewMatrix[0], localP);
   E.y = dot(u_modelViewMatrix[1], localP);
   E.z = dot(u_modelViewMatrix[2], localP);

   vec3 N;
   N.x = dot(u_normalModelViewMatrix[0], localN);
   N.y = dot(u_normalModelViewMatrix[1], localN);
   N.z = dot(u_normalModelViewMatrix[2], localN);
   N = normalize(N);

   vec3 L0 = u_omniLight0.xyz - E;
   float L0_distance = length(L0);
   L0 /= L0_distance;

   vec3 L1 = normalize(u_omniLight1.xyz - E);

   vL = (u_skyColor +
         u_omniLightColor0 * max(dot(L0, N), 0.0) * max(1.0 - L0_distance / u_omniLight0.w, 0.0) +
         u_omniLightColor1 * max(dot(L1, N), 0.0));

   gl_Position = u_mvpMatrix * localP;
}
