
uniform sampler2D tA;
uniform sampler2D tN;
uniform sampler2D tS;
uniform sampler2D tD0;
uniform sampler2D tD1;

#ifdef GL_ES

uniform lowp vec3 u_skyColor;

uniform lowp vec3 u_omniLightColor0;
uniform lowp vec3 u_omniLightColor1;

varying highp vec2 vUV;
varying highp vec2 vRUV;
varying lowp vec3 vE;
varying lowp vec3 vL0;
varying lowp float vL0I;
varying lowp vec3 vL1;
varying lowp float vDissolve;

#else

uniform vec3 u_skyColor;

uniform vec3 u_omniLightColor0;
uniform vec3 u_omniLightColor1;

varying vec2 vUV;
varying vec2 vRUV;
varying vec3 vE;
varying vec3 vL0;
varying float vL0I;
varying vec3 vL1;
varying float vDissolve;

#endif

void main(void)
{
#ifdef GL_ES

   lowp vec3 albedo;
   lowp vec3 normal;
   lowp float skinFade;
   lowp vec3 reflMap;
   lowp float specIntensity;
   lowp float light0Diffuse;
   lowp float light0Spec;
   lowp float light1Diffuse;

#else

   vec3 albedo;
   vec3 normal;
   float skinFade;
   vec3 reflMap;
   float specIntensity;
   float light0Diffuse;
   float light0Spec;
   float light1Diffuse;

#endif

   if (vDissolve > 1.0)
   {
      discard;
   }
   else
   {
      skinFade = texture2D(tD0, vUV).r;
      reflMap = texture2D(tD1, vRUV).rgb;
      albedo = texture2D(tA, vUV).rgb;
      normal = mix(texture2D(tN, vUV).xyz * 2.0 - vec3(1.0), vec3(0.0, 0.0, 1.0), skinFade + vDissolve);
      specIntensity = mix(texture2D(tS, vUV).r, 1.0, skinFade + vDissolve);

      light0Diffuse = max(dot(normal, vL0), 0.0) * vL0I;

#ifdef GL_ES
      light0Spec = max(dot(reflect(vL0, normal), vE), 0.0);
#else
      light0Spec = max(dot(reflect(vL0, normal), vE), 0.0) * max(-sign(dot(normal, vE)), 0.0) * max(sign(dot(normal, vL0)), 0.0);
#endif

      light0Spec *= light0Spec;
      light0Spec *= light0Spec;
      light0Spec *= vL0I;
      light0Spec *= specIntensity;

      light1Diffuse = max(dot(normal, vL1), 0.0);

      gl_FragColor.rgb = mix(mix(albedo * ((u_omniLightColor0 * light0Diffuse) + (u_omniLightColor1 * light1Diffuse) + u_skyColor), reflMap, skinFade) + u_omniLightColor0 * light0Spec, vec3(0.0, 0.0, 0.0), vDissolve);
   }
}
