
uniform sampler2D tA;
uniform sampler2D tD0;
uniform sampler2D tD1;

#ifdef GL_ES

varying highp vec2 vUV;
varying highp vec2 vRUV;
varying lowp vec3 vL;
varying lowp float vDissolve;

#else

varying vec2 vUV;
varying vec2 vRUV;
varying vec3 vL;
varying float vDissolve;

#endif

void main(void)
{
#ifdef GL_ES
   lowp float skinFade;
#else
   float skinFade;
#endif

   if (vDissolve > 1.0)
   {
      discard;
   }
   else
   {
      skinFade = texture2D(tD0, vUV).r;

      gl_FragColor.rgb = mix(texture2D(tA, vUV).rgb * vL, texture2D(tD1, vRUV).rgb, skinFade);
   }
}
