
attribute vec4 aV;
attribute vec4 aC;

uniform mat4 u_mvpMatrix;
uniform vec4 u_modelMatrix[3];

uniform float u_unitTimeCycle;
uniform float u_animPhase;

varying vec2 vUV;
varying float vIntensity;

void main(void)
{
   gl_Position = u_mvpMatrix * aV;

   float t = u_unitTimeCycle + u_animPhase;

   vec2 uv;
   uv.x = dot(u_modelMatrix[0], aV) * 0.05 + t * 1.0;
   uv.y = dot(u_modelMatrix[1], aV) * 0.05 - t * 1.0;

   vUV = uv;
   vIntensity = aC.r * 2.0;
}
