
attribute vec2 aV;
attribute vec2 aUV0;

uniform vec4 u_modelMatrix[3];
uniform mat4 u_viewProjMatrix;
uniform vec3 u_eyePosition;

uniform vec2 u_billboardScale;

varying vec2 vUV;

void main(void)
{
   vec3 P;
   P.x = u_modelMatrix[0].w;
   P.y = u_modelMatrix[1].w;
   P.z = u_modelMatrix[2].w;

   vec3 E = normalize(P - u_eyePosition);

   vec3 UP = vec3(0.0, 0.0, 1.0);
   vec3 SIDE = cross(E, UP);

   vec3 FINAL = P;
   FINAL += SIDE * (aV.x * u_billboardScale.x);
   FINAL += UP * (aV.y * u_billboardScale.y);

   gl_Position = u_viewProjMatrix * vec4(FINAL, 1.0);

   vUV = aUV0;
}
