
attribute vec4 aV;
attribute vec4 aC;

uniform mat4 u_mvpMatrix;

uniform float u_unitTimeCycle;
uniform float u_animPhase;

varying vec2 vUV0;
varying vec2 vUV1;
varying float vFade;

void main(void)
{
   gl_Position = u_mvpMatrix * aV;

   vec2 uv = aV.xy * 0.1;
   uv.y *= 0.3;

   vUV0 = uv;
   vUV1 = uv;

   float T = u_unitTimeCycle + u_animPhase;
   vUV0.x += -T * 2.0;
   vUV0.y += T * 1.0;
   vUV1.x += T * 3.0;
   vUV1.y += -T * 2.0;

   vFade = aC.r;
}
