
attribute vec4 aV;
attribute vec4 aC;

uniform mat4 u_mvpMatrix;

uniform float u_unitTimeCycle;
uniform float u_radianTimeCycle;

uniform float u_animPhase;

varying vec2 vUV0;
varying vec2 vUV1;
varying float vFade;

void main(void)
{
   gl_Position = u_mvpMatrix * aV;

   vec2 uv = aV.xz * 0.22;
   float d = length(uv);

   //float T = 0.0;
   //vUV0 = uv * ((d + 0.5) + sin(T * 0.000931 + d * 25.56124) * 0.18);
   //vUV1 = uv * ((d + 0.5) + sin(T * 0.001337 + d * 21.7231) * 0.14);

   //vUV0.x += T * 0.0000223;
   //vUV0.y += T * 0.0000217;
   //vUV1.x += T * 0.0000331;
   //vUV1.y += -T * 0.0000295;

   vUV0 = uv * ((d + 0.5) + sin(u_radianTimeCycle * 5.0 + d * 25.56124) * 0.18);
   vUV1 = uv * ((d + 0.5) + sin(u_radianTimeCycle * 6.0 + d * 21.7231) * 0.14);

   float t = u_animPhase + u_unitTimeCycle;

   vUV0.x += t * 2.0;
   vUV0.y += t * 1.0;
   vUV1.x += t * 3.0;
   vUV1.y += -t * 2.0;

   vFade = aC.r;
}
