
uniform sampler2D tD0;
uniform sampler2D tD1;

#ifdef GL_ES

uniform lowp vec4 u_color;
uniform mediump float u_indiePixelSize;

varying highp vec2 vUV0;
//varying highp vec2 vUV1;
//varying highp vec2 vUV2;

const mediump float POSTERIZE_LEVELS = 8.0;

#else

uniform vec4 u_color;
//uniform float u_radianTimeCycle;
uniform float u_indiePixelSize;

varying vec2 vUV0;
//varying vec2 vUV1;
//varying vec2 vUV2;

const float POSTERIZE_LEVELS = 8.0;

#endif

void main(void)
{
#ifdef GL_ES
   mediump float d;
   mediump vec2 p;
   mediump vec3 c;
   mediump float lum;
   mediump float dither;
   lowp vec4 s;
#else
   float d;
   vec2 p;
   vec3 c;
   float lum;
   float dither;
   vec4 s;
#endif

   //vUV1 = uv + vec2(sin(aV.x * 7.6345) * 0.008, 0.0);
   //vUV2 = uv + vec2(sin(aV.x * 9.1739 + 0.01) * 0.008, 0.0);

   //d = length(vUV0 - vec2(0.5));
   //p = (vUV0 - vec2(0.5)) * (1.0 + d * 0.1) + vec2(0.5);
   //c = texture2D(tD0, p).rgb;
   c = texture2D(tD0, vUV0).rgb;

   //c.r = texture2D(tD0, p).r;
   //c.g = texture2D(tD0, p + vec2(sin(vUV0.y * 197.6345 + u_radianTimeCycle * 257.0) * 0.0004, 0.0)).g;
   //c.b = texture2D(tD0, p + vec2(sin(vUV0.y * 259.1739 + u_radianTimeCycle * 312.0 + 0.01) * 0.0004, 0.0)).b;

   c = (c - vec3(0.18)) * 1.2 + vec3(0.18);

   lum = (0.2126 * c.r + 0.7152 * c.g + 0.0722 * c.b);

   c = (c - vec3(lum)) * 1.8 + vec3(lum);

   dither = mod(floor(gl_FragCoord.x / u_indiePixelSize) + floor(gl_FragCoord.y / u_indiePixelSize), 2.0);

   c = floor(c * POSTERIZE_LEVELS + vec3(floor(dither) * 0.5)) / POSTERIZE_LEVELS;

   s = texture2D(tD1, vUV0);

   gl_FragColor.rgb = mix(c, s.rgb, s.a);
   //gl_FragColor.rgb = vec3(lum, 0.0, 0.0);
   //gl_FragColor.rgb = vec3(gl_FragCoord.x);
}
