
attribute vec4 aV;
attribute vec4 aUV;
attribute vec4 aC;

uniform mat4 u_mvpMatrix;

uniform float u_unitTimeCycle;
uniform float u_radianTimeCycle;

uniform float u_anim;

varying vec2 vUV0;
varying vec2 vUV1;
varying float vFade;

void main(void)
{
   vec4 p = aV;

   float mt1 = u_radianTimeCycle * 5.0;
   float mt2 = u_radianTimeCycle * 3.0;
   float mt3 = u_radianTimeCycle * 4.0;
   float mt4 = u_radianTimeCycle * 6.0;

   float xs = sin(mt1) * cos(mt2);
   float zs = sin(mt3) * cos(mt4);

   float m = p.y / 20.0;
   m = m * m;

   //p.x *= 3.0;
   //p.z *= 1.5;

   //p.x += xs * m * 6.0;
   //p.z += zs * m * 6.0;

   gl_Position = u_mvpMatrix * p;

   vUV0 = aUV.xy * vec2(1.0, 0.22);
   vUV1 = aUV.xy * vec2(1.0, 0.8);

   vUV0.x += -u_unitTimeCycle * 4.0;
   vUV0.y += u_unitTimeCycle * 43.0;
   vUV1.x += u_unitTimeCycle * 6.0 + p.y * 0.02;
   vUV1.y += u_unitTimeCycle * 28.0;

   vFade = max(aC.r - u_anim, 0.0);
}
