
attribute vec2 aV;
attribute vec2 aUV0;

uniform vec3 u_matrix2D[2];

uniform float u_radianTimeCycle;

varying vec2 vUV0;
varying vec2 vUV1;

void main(void)
{
   vec2 P;
   P.x = dot(u_matrix2D[0], vec3(aV, 1.0));
   P.y = dot(u_matrix2D[1], vec3(aV, 1.0));

   gl_Position = vec4(P, 0.0, 1.0);

   vec2 uv = aUV0;
   uv.x = uv.x - 0.5;
   uv.y = uv.y - 0.5;

   float s = sin(u_radianTimeCycle * 45.0);
   float c = cos(u_radianTimeCycle * 45.0);

   vec2 rotatedUVs;
   rotatedUVs.x = uv.x * c - uv.y * s + 0.5;
   rotatedUVs.y = uv.y * c + uv.x * s + 0.5;

   vUV0 = aUV0;
   vUV1 = rotatedUVs;
}
