
attribute vec4 aV;
attribute vec3 aN;

uniform mat4 u_mvpMatrix;
uniform vec4 u_modelViewMatrix[3];
uniform vec3 u_normalModelViewMatrix[3];

varying vec2 vUV;

void main(void)
{
   vec3 E;
   E.x = dot(u_modelViewMatrix[0], aV);
   E.y = dot(u_modelViewMatrix[1], aV);
   E.z = dot(u_modelViewMatrix[2], aV);

   gl_Position = u_mvpMatrix * aV;

   vec3 N;
   N.x = dot(u_normalModelViewMatrix[0], aN);
   N.y = dot(u_normalModelViewMatrix[1], aN);
   N.z = dot(u_normalModelViewMatrix[2], aN);
   N = normalize(N);

   vec3 R = reflect(normalize(E), N);

   R.z = R.z + 1.0;
   vUV = R.xy / (2.0 * length(R)) + vec2(0.5, 0.5);
}
