
attribute vec4 aV;
attribute vec3 aN;

uniform mat4 u_mvpMatrix;
uniform vec4 u_modelViewMatrix[3];
uniform vec3 u_normalModelViewMatrix[3];

uniform vec4 u_omniLight0; // pos_x, pos_y, pos_z, decay_distance
uniform vec3 u_omniLightColor0;

varying vec2 vRUV;
varying vec3 vS;

void main(void)
{
   vec3 E;
   E.x = dot(u_modelViewMatrix[0], aV);
   E.y = dot(u_modelViewMatrix[1], aV);
   E.z = dot(u_modelViewMatrix[2], aV);

   gl_Position = u_mvpMatrix * aV;

   vec3 N;
   N.x = dot(u_normalModelViewMatrix[0], aN);
   N.y = dot(u_normalModelViewMatrix[1], aN);
   N.z = dot(u_normalModelViewMatrix[2], aN);
   N = normalize(N);

   vec3 L0 = u_omniLight0.xyz - E;
   float L0_distance = length(L0);

   float L0I = max(1.0 - L0_distance / u_omniLight0.w, 0.0);
   L0 /= L0_distance;

   E = normalize(E);

   vec3 R = reflect(E, N);

   R.z = R.z + 1.0;
   R.z = 2.0 * length(R);
   vRUV = R.xy / R.z + vec2(0.5, 0.5);

   vS = u_omniLightColor0 * (max(dot(reflect(L0, N), E), 0.0) * 2.0 * L0I);
}
