
attribute vec4 aV;
attribute vec4 aSA;
attribute vec4 aSB;
attribute vec4 aSC;

varying vec2 vUV;
varying vec3 vL;
varying float vF;

#ifdef GL_ES
#else
varying float vMarker;
#endif

void main(void)
{
   vec4 vertexPos = vec4(aV.x, aV.y, aV.z, 1.0);
   vec3 vertexNormal = vec3(aV.w, aSA.x, aSA.y);
   vUV = aSB.zw;

   int bi0 = int(aSC.w);
   int bi2 = bi0 / 1024;
   bi0 -= bi2 * 1024;
   int bi1 = bi0 / 32;
   bi0 -= bi1 * 32;

   vec4 bvx = u_boneMatrices[bi0 * 3    ] * aSC.x + u_boneMatrices[bi1 * 3    ] * aSC.y + u_boneMatrices[bi2 * 3    ] * aSC.z;
   vec4 bvy = u_boneMatrices[bi0 * 3 + 1] * aSC.x + u_boneMatrices[bi1 * 3 + 1] * aSC.y + u_boneMatrices[bi2 * 3 + 1] * aSC.z;
   vec4 bvz = u_boneMatrices[bi0 * 3 + 2] * aSC.x + u_boneMatrices[bi1 * 3 + 2] * aSC.y + u_boneMatrices[bi2 * 3 + 2] * aSC.z;

   vec4 localP = transformPosePointToLocal(vertexPos, bvx, bvy, bvz);
   vec3 localN = transformPoseVectorToLocal(vertexNormal, bvx, bvy, bvz);

   gl_Position = transformLocalPointToScreen(localP);

   vec3 E = transformLocalPointToView(localP);
   vec3 N = normalize(transformLocalVectorToView(localN));

   vL = u_skyColor + calculateLight0DiffusionAtViewPoint(E, N) + calculateLight1DiffusionAtViewPoint(E, N);

   vF = calculateFogIntensityAtLocalPoint(localP);

#ifdef GL_ES
#else
   if (vUV.x < 0.0)
   {
      vUV.x = -vUV.x;
      vMarker = 1.0;
   }
   else
   {
      vMarker = 0.0;
   }
#endif
}
