
attribute vec4 aV;
attribute vec4 aSA;
attribute vec4 aSB;
attribute vec4 aSC;

varying vec2 vUV;
varying vec3 vE;
varying vec3 vL0;
varying float vL0I;
varying vec3 vL1;

#ifdef GL_ES
#else
varying float vMarker;
#endif

void main(void)
{
   vec4 vertexPos = vec4(aV.x, aV.y, aV.z, 1.0);
   vec3 vertexNormal = vec3(aV.w, aSA.x, aSA.y);
   vec3 vertexTangent = vec3(aSA.z, aSA.w, aSB.x);
   vUV = aSB.zw;

   int bi0 = int(aSC.w);
   int bi2 = bi0 / 1024;
   bi0 -= bi2 * 1024;
   int bi1 = bi0 / 32;
   bi0 -= bi1 * 32;

   vec4 bvx = u_boneMatrices[bi0 * 3    ] * aSC.x + u_boneMatrices[bi1 * 3    ] * aSC.y + u_boneMatrices[bi2 * 3    ] * aSC.z;
   vec4 bvy = u_boneMatrices[bi0 * 3 + 1] * aSC.x + u_boneMatrices[bi1 * 3 + 1] * aSC.y + u_boneMatrices[bi2 * 3 + 1] * aSC.z;
   vec4 bvz = u_boneMatrices[bi0 * 3 + 2] * aSC.x + u_boneMatrices[bi1 * 3 + 2] * aSC.y + u_boneMatrices[bi2 * 3 + 2] * aSC.z;

   vec4 localP = transformPosePointToLocal(vertexPos, bvx, bvy, bvz);
   vec3 localN = transformPoseVectorToLocal(vertexNormal, bvx, bvy, bvz);
   vec3 localT = transformPoseVectorToLocal(vertexTangent, bvx, bvy, bvz);

   gl_Position = transformLocalPointToScreen(localP);

   vec3 E = transformLocalPointToView(localP);
   vec3 N = transformLocalVectorToView(localN);
   vec3 T = transformLocalVectorToView(localT);

   float normMul = reciprocalLength(N);
   N *= normMul;
   T *= normMul;

   vec3 B = calculateBinormal(N, T, aSB.y);

   vE = normalize(transformViewVectorToTangent(E, T, B, N));

   vec3 L0 = u_omniLight0.xyz - E;
   float L0_distance = length(L0);

   vL0 = transformViewVectorToTangent(L0, T, B, N) / L0_distance;
   vL0I = calculateLight0Intensity(L0_distance);

   vL1 = transformViewVectorToTangent(calculateNormalizedDeltaVector(E, u_omniLight1.xyz), T, B, N);

#ifdef GL_ES
#else
   if (vUV.x < 0.0)
   {
      vUV.x = -vUV.x;
      vMarker = 1.0;
   }
   else
   {
      vMarker = 0.0;
   }
#endif
}
