
attribute vec2 aV;
attribute vec2 aUV0;

uniform vec4 u_modelViewMatrix[3];
uniform mat4 u_projMatrix;

uniform vec2 u_billboardScale;
uniform float u_billboardOffset;

varying vec2 vUV;

void main(void)
{
   vec3 viewPos = vec3(u_modelViewMatrix[0].w, u_modelViewMatrix[1].w, u_modelViewMatrix[2].w);

   float distance = length(viewPos);
   viewPos *= (distance + u_billboardOffset) / distance;

   gl_Position = u_projMatrix * vec4(viewPos.x + aV.x * u_billboardScale.x,
                                     viewPos.y + aV.y * u_billboardScale.y,
                                     viewPos.z, 1.0);

   vUV = aUV0;
}
