
uniform sampler2D tA;
uniform sampler2D tE;

#ifdef GL_ES

varying highp vec2 vUV;
varying lowp vec3 vL;
varying lowp float vF;

#else

varying vec2 vUV;
varying vec3 vL;
varying float vF;

#endif

void main(void)
{
#ifdef GL_ES
   lowp vec3 C;
   lowp float E;
#else
   vec3 C;
   float E;
#endif

   C = texture2D(tA, vUV).rgb;
   E = texture2D(tE, vUV).r;

   gl_FragColor.rgb = mix(C * vL + u_color.rgb * E, u_fogColor, vF);
}
