
uniform sampler2D tA;
uniform sampler2D tD0;

#ifdef GL_ES

varying highp vec2 vUV;
varying highp vec2 vDecalUV0;
varying highp vec2 vDecalUV1;
varying lowp vec3 vL;
varying lowp float vF;
varying lowp float vTexBlend;

#else

varying vec2 vUV;
varying vec2 vDecalUV0;
varying vec2 vDecalUV1;
varying vec3 vL;
varying float vF;
varying float vTexBlend;

#endif

void main(void)
{
#ifdef GL_ES
   lowp vec3 C;
   lowp vec3 DC;
#else
   vec3 C;
   vec3 DC;
#endif

   C = texture2D(tA, vUV).rgb;

   DC = texture2D(tD0, vDecalUV0).rgb;
   DC *= texture2D(tD0, vDecalUV1).rgb;

   gl_FragColor.rgb = mix(mix(C, DC, vTexBlend) * vL, u_fogColor, vF);
}
