
attribute vec4 aV;
attribute vec3 aN;
attribute vec4 aUV;
attribute vec4 aC;

varying vec2 vUV;
varying vec2 vDecalUV0;
varying vec2 vDecalUV1;
varying vec3 vL;
varying float vF;
varying float vTexBlend;

void main(void)
{
   gl_Position = transformLocalPointToScreen(aV);
   vUV = aUV.xy;

   vec3 E = transformLocalPointToView(aV);
   vec3 N = normalize(transformLocalVectorToView(aN));

   vL = (u_skyColor + calculateLight0DiffusionAtViewPoint(E, N) + calculateLight1DiffusionAtViewPoint(E, N));

   vec3 W = transformLocalPointToWorld(aV);

   vF = calculateFogIntensityAtWorldZ(W.z);

   vDecalUV0 = W.xy * 0.069 + vec2(u_unitTimeCycle, 0.0);
   vDecalUV1 = W.xy * 0.078713 + vec2(0.0, u_unitTimeCycle);

   vTexBlend = aC.r;
}
