
uniform sampler2D tA;
uniform sampler2D tN;

#ifdef GL_ES

varying highp vec2 vUV;
varying lowp vec3 vL0;
varying lowp float vL0I;
varying lowp vec3 vL1;
varying lowp float vF;

#else

varying vec2 vUV;
varying vec3 vL0;
varying float vL0I;
varying vec3 vL1;
varying float vF;

#endif

void main(void)
{
#ifdef GL_ES
   lowp vec3 A;
   lowp vec3 N;
   lowp float L0D;
   lowp float L1D;
#else
   vec3 A;
   vec3 N;
   float L0D;
   float L1D;
#endif

   A = texture2D(tA, vUV).rgb;
   N = texture2D(tN, vUV).xyz * 2.0 - vec3(1.0);

   L0D = max(dot(N, vL0), 0.0) * vL0I;
   L1D = max(dot(N, vL1), 0.0);

   gl_FragColor.rgb = mix(A * ((u_omniLightColor0 * L0D) + (u_omniLightColor1 * L1D) + u_skyColor), u_fogColor, vF);
}
