
uniform sampler2D tA;
uniform sampler2D tN;
uniform sampler2D tD0;

#ifdef GL_ES

varying highp vec2 vUV;
varying highp vec2 vDecalUV;
varying lowp vec3 vL0;
varying lowp float vL0I;
varying lowp vec3 vL1;
varying lowp float vF;
varying lowp float vTexBlend;

#else

varying vec2 vUV;
varying vec2 vDecalUV;
varying vec3 vL0;
varying float vL0I;
varying vec3 vL1;
varying float vF;
varying float vTexBlend;

#endif

void main(void)
{
#ifdef GL_ES
   lowp vec3 C;
   lowp vec3 DC;
   lowp vec3 N;
   lowp float L0D;
   lowp float L1D;
   lowp vec3 FC;
#else
   vec3 C;
   vec3 DC;
   vec3 N;
   float L0D;
   float L1D;
   vec3 FC;
#endif

   C = texture2D(tA, vUV).rgb;

   N = texture2D(tN, vUV).xyz * 2.0 - vec3(1.0);

   N = mix(N, vec3(0.0, 0.0, 1.0), vTexBlend);

   DC = texture2D(tD0, vDecalUV).rgb;

   L0D = max(dot(N, vL0), 0.0) * vL0I;
   L1D = max(dot(N, vL1), 0.0);

   FC = mix(C, DC, vTexBlend) * ((u_omniLightColor0 * L0D) + (u_omniLightColor1 * L1D) + u_skyColor);

   gl_FragColor.rgb = mix(FC, u_fogColor, vF);
}
