
attribute vec4 aV;
attribute vec3 aN;
attribute vec4 aT;
attribute vec4 aUV;
attribute vec4 aC;

varying vec2 vUV;
varying vec2 vDecalUV0;
varying vec2 vDecalUV1;
varying vec3 vL0;
varying float vL0I;
varying vec3 vL1;
varying float vF;
varying float vTexBlend;

void main(void)
{
   gl_Position = transformLocalPointToScreen(aV);
   vUV = aUV.xy;

   vec3 E = transformLocalPointToView(aV);
   vec3 N = transformLocalVectorToView(aN);
   vec3 T = transformLocalVectorToView(aT.xyz);

   float normMul = reciprocalLength(N);
   N *= normMul;
   T *= normMul;

   vec3 B = calculateBinormal(N, T, aT.w);

   vec3 L0 = u_omniLight0.xyz - E;
   float L0_distance = length(L0);

   vL0 = transformViewVectorToTangent(L0, T, B, N) / L0_distance;
   vL0I = calculateLight0Intensity(L0_distance);

   vL1 = transformViewVectorToTangent(calculateNormalizedDeltaVector(E, u_omniLight1.xyz), T, B, N);

   vec3 W = transformLocalPointToWorld(aV);

   vF = calculateFogIntensityAtWorldZ(W.z);

   vDecalUV0 = W.xy * 0.069 + vec2(u_unitTimeCycle, 0.0);
   vDecalUV1 = W.xy * 0.078713 + vec2(0.0, u_unitTimeCycle);

   vTexBlend = aC.r;
}
