
uniform sampler2D tA;
uniform sampler2D tN;
uniform sampler2D tD0;

#ifdef GL_ES

varying highp vec2 vUV;
varying highp vec2 vRUV;
varying lowp vec3 vL0;
varying lowp float vL0I;
varying lowp vec3 vL1;

#else

varying vec2 vUV;
varying vec2 vRUV;
varying vec3 vL0;
varying float vL0I;
varying vec3 vL1;

#endif

void main(void)
{
#ifdef GL_ES
   lowp vec3 C;
   lowp vec3 F;
   lowp vec3 CE;
   lowp vec3 N;
   lowp float L0D;
   lowp float L1D;
#else
   vec3 C;
   vec3 F;
   vec3 CE;
   vec3 N;
   float L0D;
   float L1D;
#endif

   C = texture2D(tA, vUV).rgb;

   N = texture2D(tN, vUV).xyz * 2.0 - vec3(1.0);

   CE = texture2D(tD0, vRUV).rgb;

   L0D = max(dot(N, vL0), 0.0) * vL0I;
   L1D = max(dot(N, vL1), 0.0);

   F = C * ((u_omniLightColor0 * L0D) + (u_omniLightColor1 * L1D) + u_skyColor);

   gl_FragColor.rgb = F + CE * clamp(0.9 - (C.r + L0D + L1D), 0.0, 1.0);
}
