
uniform sampler2D tA;
uniform sampler2D tN;
uniform sampler2D tS;
uniform sampler2D tE;

#ifdef GL_ES

varying highp vec2 vUV;
varying lowp vec3 vE;
varying lowp vec3 vL0;
varying lowp float vL0I;
varying lowp vec3 vL1;

#else

varying vec2 vUV;
varying vec3 vE;
varying vec3 vL0;
varying float vL0I;
varying vec3 vL1;

#endif

void main(void)
{
#ifdef GL_ES
   lowp vec3 C;
   lowp vec3 N;
   lowp float E;
   lowp float SI;
   lowp float L0D;
   lowp float L0S;
   lowp float L1D;
#else
   vec3 C;
   vec3 N;
   float E;
   float SI;
   float L0D;
   float L0S;
   float L1D;
#endif

   C = texture2D(tA, vUV).rgb;
   N = texture2D(tN, vUV).xyz * 2.0 - vec3(1.0);
   E = texture2D(tE, vUV).r;

   L1D = max(dot(N, vL1), 0.0);

   SI = texture2D(tS, vUV).r;

   L0D = max(dot(N, vL0), 0.0) * vL0I;

#ifdef GL_ES
   L0S = max(dot(reflect(vL0, N), vE), 0.0);
#else
   L0S = max(dot(reflect(vL0, N), vE) * max(-sign(dot(N, vE)), 0.0) * max(sign(dot(N, vL0)), 0.0), 0.0);
#endif

   L0S *= L0S;
   L0S *= L0S;

   L0S *= vL0I;
   L0S *= SI;

   gl_FragColor.rgb = C * ((u_omniLightColor0 * L0D) + (u_omniLightColor1 * L1D) + u_skyColor) + u_color.rgb * E + u_omniLightColor0 * L0S;
}
