
attribute vec4 aV;
attribute vec3 aN;
attribute vec4 aUV;

varying vec2 vUV;
varying vec3 vL;
varying vec3 vS;

void main(void)
{
   gl_Position = transformLocalPointToScreen(aV);
   vUV = aUV.xy;

   vec3 E = transformLocalPointToView(aV);
   vec3 N = normalize(transformLocalVectorToView(aN));

   vec3 L0 = u_omniLight0.xyz - E;
   float L0_distance = length(L0);
   L0 /= L0_distance;

   float L0I = calculateLight0Intensity(L0_distance);

   vec3 L1 = calculateNormalizedDeltaVector(E, u_omniLight1.xyz);

   vL = (u_skyColor + u_omniLightColor0 * max(dot(L0, N), 0.0) * L0I + calculateLight1DiffusionAtViewPoint(E, N));

#ifdef GL_ES
   vS = u_omniLightColor0 * (pow(max(dot(reflect(L0, N), normalize(E)), 0.0), 4.0) * L0I);
#else
   E = normalize(E);
   vS = u_omniLightColor0 * (pow(max(dot(reflect(L0, N), E), 0.0) * max(-sign(dot(N, E)), 0.0) * max(sign(dot(N, L0)), 0.0), 4.0) * L0I);
#endif
}
