
attribute vec4 aV;
attribute vec4 aUV;
attribute vec4 aC;

uniform mat4 u_mvpMatrix;

uniform float u_unitTimeCycle;
uniform float u_animPhase;

varying vec2 vUV0;
varying vec2 vUV1;
varying float vFade;

void main(void)
{
   gl_Position = u_mvpMatrix * aV;

   vUV0 = aUV.xy;
   vUV1 = aUV.xy;

   float T = u_unitTimeCycle + u_animPhase;
   vUV0.x += -T * 8.0;
   vUV0.y += -T * 4.0;
   vUV1.x += T * 5.0;
   vUV1.y += T * 14.0;

   vFade = 1.0 - aC.r;
}
