
attribute vec4 aV;
attribute vec3 aN;
attribute vec4 aUV;

varying vec2 vUV0;
varying vec2 vUV1;
varying vec3 vL;
varying float vF;
varying float vFlatness;

const float TOP_UV_SCALE = 0.1;

void main(void)
{
   gl_Position = transformLocalPointToScreen(aV);
   vUV0 = aUV.xy;

   vec3 E = transformLocalPointToView(aV);
   vec3 N = normalize(transformLocalVectorToView(aN));

   vL = u_skyColor + calculateLight0DiffusionAtViewPoint(E, N) + calculateLight1DiffusionAtViewPoint(E, N);

   vec3 W = transformLocalPointToWorld(aV);

   vUV1 = vec2(W.x, W.y) * TOP_UV_SCALE;

   vF = calculateFogIntensityAtWorldZ(W.z);

   vFlatness = clamp((max(aN.z, 0.0) - 0.4) * 4.0 + 0.4, 0.0, 1.0);
}
