
uniform sampler2D tD0;
uniform sampler2D tD1;
uniform sampler2D tN;

#ifdef GL_ES

varying highp vec2 vUV0;
varying highp vec2 vUV1;
varying lowp vec3 vL0;
varying lowp float vL0I;
varying lowp vec3 vL1;
varying lowp float vF;
varying lowp float vFlatness;

#else

varying vec2 vUV0;
varying vec2 vUV1;
varying vec3 vL0;
varying float vL0I;
varying vec3 vL1;
varying float vF;
varying float vFlatness;

#endif

void main(void)
{
#ifdef GL_ES
   lowp vec3 C0;
   lowp vec3 C1;
   lowp vec3 N;
   lowp float L0D;
   lowp float L1D;
#else
   vec3 C0;
   vec3 C1;
   vec3 N;
   float L0D;
   float L1D;
#endif

   C0 = texture2D(tD0, vUV0).rgb;
   C1 = texture2D(tD1, vUV1).rgb;

   N = texture2D(tN, vUV0).xyz * 2.0 - vec3(1.0);
   N = mix(N, vec3(0.0, 0.0, 1.0), vFlatness);

   L0D = max(dot(N, vL0), 0.0) * vL0I;
   L1D = max(dot(N, vL1), 0.0);

   gl_FragColor.rgb = mix(mix(C0, C1, vFlatness) * ((u_omniLightColor0 * L0D) + (u_omniLightColor1 * L1D) + u_skyColor), u_fogColor, vF);
}
