
attribute vec4 aV;
attribute vec3 aN;
attribute vec4 aT;
attribute vec4 aUV;

varying vec2 vUV0;
varying vec2 vUV1;
varying vec3 vL0;
varying float vL0I;
varying vec3 vL1;
varying float vF;
varying float vFlatness;

const float TOP_UV_SCALE = 0.1;

void main(void)
{
   gl_Position = transformLocalPointToScreen(aV);
   vUV0 = aUV.xy;

   vec3 E = transformLocalPointToView(aV);
   vec3 N = transformLocalVectorToView(aN);
   vec3 T = transformLocalVectorToView(aT.xyz);

   float normMul = reciprocalLength(N);
   N *= normMul;
   T *= normMul;

   vec3 B = calculateBinormal(N, T, aT.w);

   vec3 L0 = u_omniLight0.xyz - E;
   float L0_distance = length(L0);

   vL0 = transformViewVectorToTangent(L0, T, B, N) / L0_distance;
   vL0I = calculateLight0Intensity(L0_distance);

   vL1 = transformViewVectorToTangent(calculateNormalizedDeltaVector(E, u_omniLight1.xyz), T, B, N);

   vec3 W = transformLocalPointToWorld(aV);

   vUV1 = vec2(W.x, W.y) * TOP_UV_SCALE;

   vF = calculateFogIntensityAtWorldZ(W.z);

   vFlatness = clamp((max(aN.z, 0.0) - 0.4) * 4.0 + 0.4, 0.0, 1.0);
}
