
uniform sampler2D tA;

#ifdef GL_ES

varying highp vec2 vUV0;
varying highp vec2 vUV1;
varying lowp vec3 vL;
varying lowp float vF;
varying lowp float vFlatness;

#else

varying vec2 vUV0;
varying vec2 vUV1;
varying vec3 vL;
varying float vF;
varying float vFlatness;

#endif

void main(void)
{
#ifdef GL_ES
   lowp vec3 C0;
   lowp vec3 C1;
#else
   vec3 C0;
   vec3 C1;
#endif

   C0 = texture2D(tA, vUV0).rgb;
   C1 = texture2D(tA, vUV1).rgb;

   gl_FragColor.rgb = mix(mix(C0, C1, vFlatness) * vL, u_fogColor, vF);
}
