
attribute vec4 aV;
attribute vec4 aC;

uniform mat4 u_mvpMatrix;
uniform vec4 u_modelMatrix[3];

uniform float u_unitTimeCycle;
uniform float u_animPhase;
uniform float u_radianTimeCycle;

varying vec2 vUV;
varying float vIntensity;

void main(void)
{
   gl_Position = u_mvpMatrix * aV;

   float t = u_unitTimeCycle + u_animPhase;

   vec2 w;
   w.x = dot(u_modelMatrix[0], aV);
   w.y = dot(u_modelMatrix[1], aV);

   vec2 uv = w * 0.054 + vec2(t);
   uv.x += sin(w.y * 0.16) * 0.2;

   vUV = uv;
   vIntensity = aC.r;
}
