
uniform vec2 u_layerFogParams;
uniform vec3 u_skyColor;

uniform vec4 u_boneMatrices[96];

uniform mat4 u_mvpMatrix;
uniform vec4 u_modelViewMatrix[3];
uniform vec3 u_normalModelViewMatrix[3];
uniform vec4 u_modelMatrix[3];
uniform vec3 u_normalModelMatrix[3];
uniform vec3 u_eyePosition;

uniform vec4 u_omniLight0;
uniform vec4 u_omniLight1;

uniform vec3 u_omniLightColor0;
uniform vec3 u_omniLightColor1;

uniform float u_unitTimeCycle;
uniform float u_animPhase;
uniform float u_radianTimeCycle;
uniform float u_radianAnimPhase;

vec4 transformLocalPointToScreen (vec4 v)
{
   return u_mvpMatrix * v;
}

vec3 transformLocalPointToView (vec4 v)
{
   vec3 viewPoint;
   viewPoint.x = dot(u_modelViewMatrix[0], v);
   viewPoint.y = dot(u_modelViewMatrix[1], v);
   viewPoint.z = dot(u_modelViewMatrix[2], v);
   return viewPoint;
}

vec3 transformLocalPointToWorld (vec4 v)
{
   vec3 worldPoint;
   worldPoint.x = dot(u_modelMatrix[0], v);
   worldPoint.y = dot(u_modelMatrix[1], v);
   worldPoint.z = dot(u_modelMatrix[2], v);
   return worldPoint;
}

vec3 transformLocalVectorToView (vec3 v)
{
   vec3 viewVec;
   viewVec.x = dot(u_normalModelViewMatrix[0], v);
   viewVec.y = dot(u_normalModelViewMatrix[1], v);
   viewVec.z = dot(u_normalModelViewMatrix[2], v);
   return viewVec;
}

vec3 transformLocalVectorToWorld (vec3 v)
{
   vec3 worldVec;
   worldVec.x = dot(u_normalModelMatrix[0], v);
   worldVec.y = dot(u_normalModelMatrix[1], v);
   worldVec.z = dot(u_normalModelMatrix[2], v);
   return worldVec;
}

float reciprocalLength (vec3 v)
{
   return 1.0 / length(v);
}

vec3 calculateBinormal (vec3 N, vec3 T, float direction)
{
   return cross(N, T) * direction;
}

vec3 transformViewVectorToTangent (vec3 viewVec, vec3 viewTangent, vec3 viewBinormal, vec3 viewNormal)
{
   vec3 tangentVec;
   tangentVec.x = dot(viewVec, viewTangent);
   tangentVec.y = dot(viewVec, viewBinormal);
   tangentVec.z = dot(viewVec, viewNormal);
   return tangentVec;
}

float transformLocalPointZToWorld (vec4 v)
{
   return dot(u_modelMatrix[2], v);
}

vec4 transformPosePointToLocal (vec4 v, vec4 boneMatrixX, vec4 boneMatrixY, vec4 boneMatrixZ)
{
   vec4 localPoint;
   localPoint.x = dot(boneMatrixX, v);
   localPoint.y = dot(boneMatrixY, v);
   localPoint.z = dot(boneMatrixZ, v);
   localPoint.w = 1.0;
   return localPoint;
}

vec3 transformPoseVectorToLocal (vec3 v, vec4 boneMatrixX, vec4 boneMatrixY, vec4 boneMatrixZ)
{
   vec3 localVec;
   localVec.x = dot(boneMatrixX.xyz, v);
   localVec.y = dot(boneMatrixY.xyz, v);
   localVec.z = dot(boneMatrixZ.xyz, v);
   return localVec;
}

float calculateFogIntensityAtWorldZ (float worldZ)
{
   return clamp(-(worldZ - u_layerFogParams.x) / u_layerFogParams.y, 0.0, 1.0);
}

float calculateFogIntensityAtLocalPoint (vec4 v)
{
   return calculateFogIntensityAtWorldZ(transformLocalPointZToWorld(v));
}

vec3 calculateNormalizedDeltaVector (vec3 from, vec3 to)
{
   return normalize(to - from);
}

float calculateLight0Intensity (float distanceFromLight)
{
   return max(1.0 - distanceFromLight / u_omniLight0.w, 0.0);
}

vec3 calculateLight0DiffusionAtViewPoint (vec3 viewPoint, vec3 viewNormal)
{
   vec3 deltaToLight = u_omniLight0.xyz - viewPoint;
   float distanceFromLight = length(deltaToLight);
   float intensity = calculateLight0Intensity(distanceFromLight);
   return u_omniLightColor0 * max(dot(deltaToLight / distanceFromLight, viewNormal), 0.0) * intensity;
}

vec3 calculateLight1DiffusionAtViewPoint (vec3 viewPoint, vec3 viewNormal)
{
   vec3 deltaToLight = calculateNormalizedDeltaVector(viewPoint, u_omniLight1.xyz);
   return u_omniLightColor1 * max(dot(deltaToLight, viewNormal), 0.0);
}
