#!/system/bin/sh 

chmod 0755 /system/bin/input_boost
chmod 0755 /system/etc/yunos_sensor_init.sh


if [ ! -d "/data/yunos" ]; then
	mkdir /data/yunos
fi
chmod 0755 /data/yunos

if [ ! -d "/data/yunos/bin" ]; then
	mkdir /data/yunos/bin
fi
chmod 0755 /data/yunos/bin

if [ ! -d "/data/yunos/lib" ]; then
	mkdir /data/yunos/lib
fi
chmod 0755 /data/yunos/lib

if [ ! -d "/data/yunos/lib/hw" ]; then
	mkdir /data/yunos/lib/hw
fi
chmod 0755 /data/yunos/lib/hw

if [ ! -d "/data/yunos/cfg" ]; then
	mkdir /data/yunos/cfg
fi
chmod 0755 /data/yunos/cfg


input_boost_path="/data/yunos/bin/input_boost"
sensor_so_path="/data/yunos/lib/hw/sensors.yunos.so"
sensor_cfg_path="/data/yunos/cfg/ali-sensor.cfg"
game_cfg_path="/data/yunos/cfg/ali-gamelist.cfg"

if [ ! -f $sensor_so_path ]; then
	echo "cp sensor so"
	busybox cp /system/lib/hw/sensors.yunos.so /data/yunos/lib/hw/sensors.yunos.so
fi
chmod 755 /data/yunos/lib/hw/sensors.yunos.so

if [ ! -f $sensor_cfg_path ]; then
	echo "cp sensor cfg"
	busybox cp /system/usr/ali-sensor.cfg /data/yunos/cfg/ali-sensor.cfg
fi
chmod 664 /data/yunos/cfg/ali-sensor.cfg

if [ ! -f $game_cfg_path ]; then
	echo "cp sensor cfg"
	busybox cp /system/usr/ali-gamelist.cfg /data/yunos/cfg/ali-gamelist.cfg
fi
chmod 664 /data/yunos/cfg/ali-gamelist.cfg

if [ ! -f $input_boost_path ]; then
	echo "cp input_boost"
	busybox cp /system/bin/input_boost /data/yunos/bin/input_boost
fi

size=`ls -l /data/yunos/bin/input_boost | busybox awk '{print $4}'`

if [ $size -lt 60000  ]; then
	echo "cp input_boost"
	busybox cp /system/bin/input_boost /data/yunos/bin/input_boost
fi

chmod 744 /data/yunos/bin/input_boost

chmod 744 /system/bin/input_boost_helper

/system/bin/input_boost_helper&
echo "start input_boost"
/data/yunos/bin/input_boost

