/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;
import sun.nio.cs.ext.DoubleByte;

public abstract class CharToByteDBCS_ASCII2
extends CharToByteConverter {
    private char highHalfZoneCode;
    private byte[] outputByte = new byte[2];
    private DoubleByte.Encoder enc;

    public CharToByteDBCS_ASCII2(DoubleByte.Encoder encoder) {
        this.enc = encoder;
    }

    int encodeChar(char c) {
        return this.enc.encodeChar(c);
    }

    public int flush(byte[] byArray, int n, int n2) throws MalformedInputException, ConversionBufferFullException {
        if (this.highHalfZoneCode != '\u0000') {
            this.reset();
            this.badInputLength = 0;
            throw new MalformedInputException();
        }
        this.reset();
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int convert(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws UnknownCharacterException, MalformedInputException, ConversionBufferFullException {
        this.byteOff = n3;
        this.charOff = n;
        while (this.charOff < n2) {
            int n5;
            char c;
            if (this.highHalfZoneCode == '\u0000') {
                c = cArray[this.charOff];
                n5 = 1;
            } else {
                c = this.highHalfZoneCode;
                n5 = 0;
                this.highHalfZoneCode = '\u0000';
            }
            if (Character.isHighSurrogate(c)) {
                if (this.charOff + n5 >= n2) {
                    this.highHalfZoneCode = c;
                    this.charOff += n5;
                    return this.byteOff - n3;
                }
                c = cArray[this.charOff + n5];
                if (!Character.isLowSurrogate(c)) {
                    this.badInputLength = 1;
                    throw new MalformedInputException();
                }
                if (!this.subMode) {
                    this.badInputLength = 2;
                    throw new UnknownCharacterException();
                }
                if (this.subBytes.length == 1) {
                    this.outputByte[0] = 0;
                    this.outputByte[1] = this.subBytes[0];
                } else {
                    this.outputByte[0] = this.subBytes[0];
                    this.outputByte[1] = this.subBytes[1];
                }
                ++n5;
            } else {
                if (Character.isLowSurrogate(c)) {
                    this.badInputLength = 1;
                    throw new MalformedInputException();
                }
                int n6 = this.encodeChar(c);
                if (n6 == 65533) {
                    if (!this.subMode) {
                        this.badInputLength = 1;
                        throw new UnknownCharacterException();
                    }
                    if (this.subBytes.length == 1) {
                        this.outputByte[0] = 0;
                        this.outputByte[1] = this.subBytes[0];
                    } else {
                        this.outputByte[0] = this.subBytes[0];
                        this.outputByte[1] = this.subBytes[1];
                    }
                } else {
                    this.outputByte[0] = (byte)(n6 >> 8);
                    this.outputByte[1] = (byte)n6;
                }
            }
            int n7 = this.outputByte[0] == 0 ? 1 : 2;
            if (this.byteOff + n7 > n4) {
                throw new ConversionBufferFullException();
            }
            if (n7 == 1) {
                byArray[this.byteOff++] = this.outputByte[1];
            } else {
                byArray[this.byteOff++] = this.outputByte[0];
                byArray[this.byteOff++] = this.outputByte[1];
            }
            this.charOff += n5;
        }
        return this.byteOff - n3;
    }

    public void reset() {
        this.byteOff = 0;
        this.charOff = 0;
        this.highHalfZoneCode = '\u0000';
    }

    public int getMaxBytesPerChar() {
        return 2;
    }

    public boolean canConvert(char c) {
        return this.encodeChar(c) != 65533;
    }
}

