/*
 * Decompiled with CFR 0.152.
 */
package com.apple.crypto.provider;

import com.apple.crypto.provider.JarVerifier;
import java.io.ByteArrayInputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import sun.security.action.GetPropertyAction;

public final class Apple
extends Provider {
    private static final String info = "Apple Provider (implements DES, Triple DES, AES, Blowfish, PBE, Diffie-Hellman, HMAC/MD5, HMAC/SHA1)";
    static final boolean debug = false;
    private static boolean verifiedSelfIntegrity = false;

    public Apple() {
        super("Apple", 1.0, info);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Apple.this.put("Mac.HmacMD5", "com.apple.crypto.provider.HmacMD5");
                Apple.this.put("Mac.HmacSHA1", "com.apple.crypto.provider.HmacSHA1");
                Apple.this.put("MessageDigest.MD5", "com.apple.crypto.provider.MessageDigestMD5");
                Apple.this.put("MessageDigest.SHA", "com.apple.crypto.provider.MessageDigestSHA1");
                Apple.this.put("Alg.Alias.MessageDigest.SHA-1", "SHA");
                Apple.this.put("Alg.Alias.MessageDigest.SHA1", "SHA");
                Apple.this.put("SecureRandom.YarrowPRNG", "com.apple.crypto.provider.CSPRandom");
                Apple.this.put("KeyStore.KeychainStore", "com.apple.crypto.provider.KeychainStore");
                return null;
            }
        });
    }

    static final boolean verifySelfIntegrity(Class clazz) {
        if (verifiedSelfIntegrity) {
            return true;
        }
        return Apple.doSelfVerification(clazz);
    }

    private static final synchronized boolean doSelfVerification(Class clazz) {
        X509Certificate x509Certificate;
        Object object;
        Object object2;
        boolean bl = false;
        String string = AccessController.doPrivileged(new GetPropertyAction("com.apple.crypto.skipSelfCert", "false"));
        if (string != null) {
            bl = Boolean.valueOf(string);
        }
        if (bl) {
            verifiedSelfIntegrity = true;
            return true;
        }
        try {
            object2 = CertificateFactory.getInstance("X.509");
            object = "-----BEGIN CERTIFICATE-----\nMIIDrjCCA2ygAwIBAgICAfIwCwYHKoZIzjgEAwUAMIGQMQswCQYDVQQGEwJVUzELMAkGA1UECBMCQ0ExEjAQBgNVBAcTCVBhbG8gQWx0bzEdMBsGA1UEChMUU3VuIE1pY3Jvc3lzdGVtcyBJbmMxIzAhBgNVBAsTGkphdmEgU29mdHdhcmUgQ29kZSBTaWduaW5nMRwwGgYDVQQDExNKQ0UgQ29kZSBTaWduaW5nIENBMB4XDTA1MDMwMzIyNDEyNloXDTEwMDMwNzIyNDEyNlowXTEdMBsGA1UEChMUU3VuIE1pY3Jvc3lzdGVtcyBJbmMxIzAhBgNVBAsTGkphdmEgU29mdHdhcmUgQ29kZSBTaWduaW5nMRcwFQYDVQQDEw5BcHBsZSBDb21wdXRlcjCCAbgwggEsBgcqhkjOOAQBMIIBHwKBgQD9f1OBHXUSKVLfSpwu7OTn9hG3UjzvRADDHj+AtlEmaUVdQCJR+1k9jVj6v8X1ujD2y5tVbNeBO4AdNG/yZmC3a5lQpaSfn+gEexAiwk+7qdf+t8Yb+DtX58aophUPBPuD9tPFHsMCNVQTWhaRMvZ1864rYdcq7/IiAxmd0UgBxwIVAJdgUI8VIwvMspK5gqLrhAvwWBz1AoGBAPfhoIXWmz3ey7yrXDa4V7l5lK+7+jrqgvlXTAs9B4JnUVlXjrrUWU/mcQcQgYC0SRZxI+hMKBYTt88JMozIpuE8FnqLVHyNKOCjrh4rs6Z1kW6jfwv6ITVi8ftiegEkO8yk8b6oUZCJqIPf4VrlnwaSi2ZegHtVJWQBTDv+z0kqA4GFAAKBgQCnhxcBpO/EOpuFTmJ61BZKzOP0UnfI+PNA6RV3yTwJ/jT2YlZqAILYYv/HnoCZkdjF9TQsBhhWOcRIcuBBk0wL7pS6Gke0pU0Y8rehtbM7mo3R8GkFHiyQfqRTmmG8LoBOcl54PddjSfgLriVE5BVpBwp5pPjjpWlP3pe2NbMdiaOBhTCBgjARBglghkgBhvhCAQEEBAMCBBAwDgYDVR0PAQH/BAQDAgXgMB0GA1UdDgQWBBTt8HUAeHvPJJHiXBLfwdeaXAufaTAfBgNVHSMEGDAWgBRl4vSGydNO8JFOWKJq9dh4WprBpjAdBgNVHREEFjAUgRJza292YXRjaEBhcHBsZS5jb20wCwYHKoZIzjgEAwUAAy8AMCwCFCbxx0wdr4HvJj/EkKYnsl6wfvTNAhR/RwvkN5CUbAxyt/uacu0bpVSJTQ==\n-----END CERTIFICATE-----\n".getBytes("UTF8");
            x509Certificate = (X509Certificate)((CertificateFactory)object2).generateCertificate(new ByteArrayInputStream((byte[])object));
        }
        catch (Exception exception) {
            return false;
        }
        object2 = clazz;
        object = (URL)AccessController.doPrivileged(new PrivilegedAction((Class)object2){
            final /* synthetic */ Class val$cc;
            {
                this.val$cc = clazz;
            }

            public Object run() {
                CodeSource codeSource = this.val$cc.getProtectionDomain().getCodeSource();
                return codeSource.getLocation();
            }
        });
        if (object == null) {
            return false;
        }
        JarVerifier jarVerifier = new JarVerifier((URL)object);
        try {
            jarVerifier.verify(x509Certificate);
        }
        catch (Exception exception) {
            return false;
        }
        verifiedSelfIntegrity = true;
        return true;
    }
}

