/*
 * Decompiled with CFR 0.152.
 */
package com.apple.crypto.provider;

import com.apple.crypto.provider.Apple;
import com.apple.crypto.provider.NativeLibraryLoader;
import com.apple.crypto.provider.SeedGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandomSpi;

public class CSPRandom
extends SecureRandomSpi {
    private static CSPRandom sSeeder;
    private static final int DIGEST_SIZE = 20;
    private transient MessageDigest mDigest;
    private byte[] mState;

    public CSPRandom() {
        if (!Apple.verifySelfIntegrity(this.getClass())) {
            throw new SecurityException("The Apple provider may have been tampered.");
        }
        this.init(null);
    }

    private CSPRandom(byte[] byArray) {
        this.init(byArray);
    }

    private void init(byte[] byArray) {
        try {
            this.mDigest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError("internal error: SHA-1 not available.");
        }
        if (byArray != null) {
            this.engineSetSeed(byArray);
        }
    }

    @Override
    protected void engineSetSeed(byte[] byArray) {
        if (this.mState != null) {
            this.mDigest.update(this.mState);
            for (int i = 0; i < this.mState.length; ++i) {
                this.mState[i] = 0;
            }
        }
        this.mState = this.mDigest.digest(byArray);
    }

    @Override
    protected void engineNextBytes(byte[] byArray) {
        boolean bl = false;
        if (this.mState == null) {
            if (sSeeder == null) {
                sSeeder = new CSPRandom(SeedGenerator.getSystemEntropy());
                sSeeder.engineSetSeed(this.engineGenerateSeed(20));
            }
            byte[] byArray2 = new byte[20];
            sSeeder.engineNextBytes(byArray2);
            this.mState = this.mDigest.digest(byArray2);
        }
        this._nextBytes(this.mState, byArray);
    }

    private native void _nextBytes(byte[] var1, byte[] var2);

    @Override
    protected byte[] engineGenerateSeed(int n) {
        byte[] byArray = new byte[n];
        SeedGenerator.generateSeed(byArray);
        return byArray;
    }

    static {
        NativeLibraryLoader.loadNativeLibrary();
    }
}

