/*
 * Decompiled with CFR 0.152.
 */
package com.apple.crypto.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

public class CryptoGlobals {
    public static boolean TraceSecurity = false;
    public static boolean TraceStartup = false;
    public static boolean TraceThreads = false;
    public static boolean TraceCertificates = false;
    public static boolean TraceCDPParsing = false;
    public static boolean TraceIgnoredExceptions = false;
    public static boolean RedirectOutput = true;

    private static String getProperty(String string) {
        return System.getProperty(string);
    }

    public static String[] parseOptions(String[] stringArray) {
        Object object;
        CryptoGlobals.readOptionFile();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        boolean bl = false;
        while (n < stringArray.length) {
            if (((String)(object = stringArray[n++])).startsWith("-XX:") && !bl) {
                CryptoGlobals.parseOption(((String)object).substring(4), false);
            } else {
                arrayList.add(object);
            }
            if (((String)object).startsWith("-")) continue;
            bl = true;
        }
        object = new String[arrayList.size()];
        return arrayList.toArray((T[])object);
    }

    public static void getDebugOptionsFromProperties(Properties properties) {
        int n = 0;
        String string;
        while ((string = properties.getProperty("com.apple.crypto.provider.debug." + n)) != null) {
            CryptoGlobals.parseOption(string, true);
            ++n;
        }
        return;
    }

    private static void parseOption(String string, boolean bl) {
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(61);
        if (n == -1) {
            string2 = string;
            string3 = null;
        } else {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        if (string2.length() > 0 && (string2.startsWith("-") || string2.startsWith("+"))) {
            string2 = string2.substring(1);
            String string4 = string3 = string.startsWith("+") ? "true" : "false";
        }
        if (bl && !string2.startsWith("x") && !string2.startsWith("Trace")) {
            string2 = null;
        }
        if (string2 != null && CryptoGlobals.setOption(string2, string3)) {
            System.out.println("# Option: " + string2 + "=" + string3);
        } else {
            System.out.println("# Ignoring option: " + string);
        }
    }

    private static boolean setOption(String string, String string2) {
        boolean bl;
        block10: {
            Class<?> clazz = new String().getClass();
            bl = true;
            try {
                Field field = new CryptoGlobals().getClass().getDeclaredField(string);
                if ((field.getModifiers() & 8) == 0) {
                    return false;
                }
                Class<?> clazz2 = field.getType();
                if (clazz2 == clazz) {
                    field.set(null, string2);
                    break block10;
                }
                if (clazz2 == Boolean.TYPE) {
                    field.setBoolean(null, Boolean.valueOf(string2));
                    break block10;
                }
                if (clazz2 == Integer.TYPE) {
                    field.setInt(null, Integer.parseInt(string2));
                    break block10;
                }
                if (clazz2 == Float.TYPE) {
                    field.setFloat(null, Float.parseFloat(string2));
                    break block10;
                }
                if (clazz2 == Double.TYPE) {
                    field.setDouble(null, Double.parseDouble(string2));
                    break block10;
                }
                if (clazz2 == Long.TYPE) {
                    field.setLong(null, Long.parseLong(string2));
                    break block10;
                }
                return false;
            }
            catch (IllegalAccessException illegalAccessException) {
                return false;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                return false;
            }
        }
        return bl;
    }

    private static void readOptionFile() {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(".applecrypto");
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                fileInputStream = new FileInputStream(CryptoGlobals.getProperty("user.home") + File.separator + ".applecrypto");
            }
            catch (FileNotFoundException fileNotFoundException2) {
                return;
            }
        }
        try {
            Properties properties = new Properties();
            properties.load(fileInputStream);
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                CryptoGlobals.parseOption(string + "=" + string2, false);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

