/*
 * Decompiled with CFR 0.152.
 */
package com.apple.crypto.provider;

import com.apple.crypto.provider.Apple;
import com.apple.crypto.provider.NativeLibraryLoader;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;

abstract class HmacCore
extends MacSpi {
    private static final int HMAC_ALGORITHM_FIRST = 1;
    protected static final int HMAC_ALGORITHM_MD5 = 1;
    protected static final int HMAC_ALGORITHM_SHA1 = 2;
    private static final int HMAC_ALGORITHM_LAST = 2;
    long mCssmContext = 0L;
    int mAlgorithm;

    public HmacCore() throws NoSuchAlgorithmException {
        if (!Apple.verifySelfIntegrity(this.getClass())) {
            throw new SecurityException("The Apple provider may have been tampered.");
        }
        int n = this.getAlgorithm();
        if (n < 1 || n > 2) {
            throw new NoSuchAlgorithmException("No such algorithm available");
        }
        this.mAlgorithm = n;
    }

    protected abstract int getAlgorithm();

    @Override
    public synchronized void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("HMAC does not use parameters");
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Secret key expected");
        }
        byte[] byArray = key.getEncoded();
        if (byArray == null || byArray.length == 0) {
            throw new InvalidKeyException("Missing key data");
        }
        this.mCssmContext = this._init(byArray, this.mAlgorithm);
        if (this.mCssmContext == 0L) {
            throw new InvalidKeyException("Bad key data");
        }
    }

    private native long _init(byte[] var1, int var2);

    @Override
    protected synchronized void engineUpdate(byte by) {
        byte[] byArray = new byte[]{by};
        this._update(this.mCssmContext, byArray, 0, 1);
    }

    @Override
    public synchronized void engineUpdate(byte[] byArray, int n, int n2) {
        this._update(this.mCssmContext, byArray, n, n2);
    }

    private native void _update(long var1, byte[] var3, int var4, int var5);

    @Override
    public synchronized byte[] engineDoFinal() {
        return this._doFinal(this.mCssmContext);
    }

    private native byte[] _doFinal(long var1);

    @Override
    public synchronized void engineReset() {
        this._reset(this.mCssmContext);
    }

    private native void _reset(long var1);

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Apple Hmac implementations do not support cloning.");
    }

    static {
        NativeLibraryLoader.loadNativeLibrary();
    }
}

