/*
 * Decompiled with CFR 0.152.
 */
package com.apple.crypto.provider;

import com.apple.crypto.provider.Apple;
import com.apple.crypto.provider.NativeLibraryLoader;
import java.security.MessageDigestSpi;
import java.security.NoSuchAlgorithmException;

abstract class MessageDigestCore
extends MessageDigestSpi
implements Cloneable {
    private static final int MESSAGEDIGEST_ALGORITHM_FIRST = 1;
    protected static final int MESSAGEDIGEST_ALGORITHM_MD5 = 1;
    protected static final int MESSAGEDIGEST_ALGORITHM_MD4 = 2;
    protected static final int MESSAGEDIGEST_ALGORITHM_MD2 = 3;
    protected static final int MESSAGEDIGEST_ALGORITHM_SHA1 = 4;
    private static final int MESSAGEDIGEST_ALGORITHM_LAST = 4;
    long mCssmContext;
    int mAlgorithm;

    public MessageDigestCore() throws NoSuchAlgorithmException {
        if (!Apple.verifySelfIntegrity(this.getClass())) {
            throw new SecurityException("The Apple provider may have been tampered.");
        }
        int n = this.getAlgorithm();
        if (n < 1 || n > 4) {
            throw new NoSuchAlgorithmException("No such algorithm available");
        }
        this.mAlgorithm = n;
        this.mCssmContext = this._init(this.mAlgorithm);
    }

    private native long _init(int var1);

    protected abstract int getAlgorithm();

    @Override
    protected synchronized void engineUpdate(byte by) {
        byte[] byArray = new byte[]{by};
        this._update(this.mCssmContext, byArray, 0, 1);
    }

    @Override
    public synchronized void engineUpdate(byte[] byArray, int n, int n2) {
        this._update(this.mCssmContext, byArray, n, n2);
    }

    private native void _update(long var1, byte[] var3, int var4, int var5);

    @Override
    public synchronized byte[] engineDigest() {
        byte[] byArray = this._digest(this.mCssmContext);
        this._reset(this.mCssmContext);
        return byArray;
    }

    private native byte[] _digest(long var1);

    @Override
    public synchronized void engineReset() {
        this._reset(this.mCssmContext);
    }

    private native void _reset(long var1);

    @Override
    public synchronized Object clone() {
        MessageDigestCore messageDigestCore = null;
        try {
            messageDigestCore = (MessageDigestCore)super.clone();
            if (this.mCssmContext != 0L) {
                messageDigestCore.mCssmContext = this._cloneContext(this.mCssmContext);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return messageDigestCore;
    }

    private native long _cloneContext(long var1);

    static {
        NativeLibraryLoader.loadNativeLibrary();
    }
}

