/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import com.sun.tools.jconsole.JConsoleContext;
import com.sun.tools.jconsole.JConsolePlugin;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.TabbedPaneUI;
import sun.tools.jconsole.ClassTab;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.MBeansTab;
import sun.tools.jconsole.MemoryTab;
import sun.tools.jconsole.OverviewTab;
import sun.tools.jconsole.ProxyClient;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.SheetDialog;
import sun.tools.jconsole.SummaryTab;
import sun.tools.jconsole.Tab;
import sun.tools.jconsole.ThreadTab;
import sun.tools.jconsole.Utilities;
import sun.tools.jconsole.VMInternalFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMPanel
extends JTabbedPane
implements PropertyChangeListener {
    private ProxyClient proxyClient;
    private Timer timer;
    private int updateInterval;
    private String hostName;
    private int port;
    private int vmid;
    private String userName;
    private String password;
    private String url;
    private VMInternalFrame vmIF = null;
    private static final String windowsLaF = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    private static ArrayList<TabInfo> tabInfos = new ArrayList();
    private boolean wasConnected = false;
    private boolean shouldUseSSL = true;
    private boolean everConnected = false;
    private boolean initialUpdate = true;
    private Map<JConsolePlugin, SwingWorker<?, ?>> plugins = null;
    private boolean pluginTabsAdded = false;
    private JOptionPane optionPane;
    private JProgressBar progressBar;
    private long time0;
    private static Icon connectedIcon16;
    private static Icon connectedIcon24;
    private static Icon disconnectedIcon16;
    private static Icon disconnectedIcon24;
    private Rectangle connectedIconBounds;
    private Object lockObject = new Object();

    public static TabInfo[] getTabInfos() {
        return tabInfos.toArray(new TabInfo[tabInfos.size()]);
    }

    VMPanel(ProxyClient proxyClient, int n) {
        this.proxyClient = proxyClient;
        this.updateInterval = n;
        this.hostName = proxyClient.getHostName();
        this.port = proxyClient.getPort();
        this.vmid = proxyClient.getVmid();
        this.userName = proxyClient.getUserName();
        this.password = proxyClient.getPassword();
        this.url = proxyClient.getUrl();
        for (TabInfo object : tabInfos) {
            if (!object.tabVisible) continue;
            this.addTab(object);
        }
        this.plugins = new LinkedHashMap();
        for (JConsolePlugin jConsolePlugin : JConsole.getPlugins()) {
            jConsolePlugin.setContext(proxyClient);
            this.plugins.put(jConsolePlugin, null);
        }
        Utilities.updateTransparency(this);
        ToolTipManager.sharedInstance().registerComponent(this);
        proxyClient.addPropertyChangeListener(this);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (VMPanel.this.connectedIconBounds != null && (mouseEvent.getModifiers() & 0x10) != 0 && VMPanel.this.connectedIconBounds.contains(mouseEvent.getPoint())) {
                    if (VMPanel.this.isConnected()) {
                        VMPanel.this.disconnect();
                        VMPanel.this.wasConnected = false;
                    } else {
                        VMPanel.this.connect();
                    }
                    VMPanel.this.repaint();
                }
            }
        });
    }

    @Override
    public void setUI(TabbedPaneUI tabbedPaneUI) {
        Insets insets = (Insets)UIManager.getLookAndFeelDefaults().get("TabbedPane.tabAreaInsets");
        insets = (Insets)insets.clone();
        insets.right += connectedIcon24.getIconWidth() + 8;
        UIManager.put("TabbedPane.tabAreaInsets", insets);
        super.setUI(tabbedPaneUI);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Component component = this.getComponent(0);
        Icon icon = component != null && component.getY() > 24 ? (this.isConnected() ? connectedIcon24 : disconnectedIcon24) : (this.isConnected() ? connectedIcon16 : disconnectedIcon16);
        Insets insets = this.getInsets();
        int n = this.getWidth() - insets.right - icon.getIconWidth() - 4;
        int n2 = insets.top;
        if (component != null) {
            n2 = (component.getY() - icon.getIconHeight()) / 2;
        }
        icon.paintIcon(this, graphics, n, n2);
        this.connectedIconBounds = new Rectangle(n, n2, icon.getIconWidth(), icon.getIconHeight());
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.connectedIconBounds.contains(mouseEvent.getPoint())) {
            if (this.isConnected()) {
                return VMPanel.getText("Connected. Click to disconnect.", new Object[0]);
            }
            return VMPanel.getText("Disconnected. Click to connect.", new Object[0]);
        }
        return super.getToolTipText(mouseEvent);
    }

    private synchronized void addTab(TabInfo tabInfo) {
        Tab tab = this.instantiate(tabInfo);
        if (tab != null) {
            this.addTab(tabInfo.name, tab);
        } else {
            tabInfo.tabVisible = false;
        }
    }

    private synchronized void insertTab(TabInfo tabInfo, int n) {
        Tab tab = this.instantiate(tabInfo);
        if (tab != null) {
            this.insertTab(tabInfo.name, null, tab, null, n);
        } else {
            tabInfo.tabVisible = false;
        }
    }

    @Override
    public synchronized void removeTabAt(int n) {
        super.removeTabAt(n);
    }

    private Tab instantiate(TabInfo tabInfo) {
        try {
            Constructor<? extends Tab> constructor = tabInfo.tabClass.getConstructor(VMPanel.class);
            return constructor.newInstance(this);
        }
        catch (Exception exception) {
            System.err.println(exception);
            return null;
        }
    }

    boolean isConnected() {
        return this.proxyClient.isConnected();
    }

    public int getUpdateInterval() {
        return this.updateInterval;
    }

    ProxyClient getProxyClient(boolean bl) {
        if (bl) {
            return this.getProxyClient();
        }
        return this.proxyClient;
    }

    public ProxyClient getProxyClient() {
        String string = Thread.currentThread().getClass().getName();
        if (string.equals("java.awt.EventDispatchThread")) {
            String string2 = "Calling VMPanel.getProxyClient() from the Event Dispatch Thread!";
            new RuntimeException(string2).printStackTrace();
            System.exit(1);
        }
        return this.proxyClient;
    }

    public void cleanUp() {
        for (Tab object : this.getTabs()) {
            object.dispose();
        }
        for (JConsolePlugin jConsolePlugin : this.plugins.keySet()) {
            jConsolePlugin.dispose();
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.proxyClient.removePropertyChangeListener(this);
    }

    public void connect() {
        if (this.isConnected()) {
            this.createPluginTabs();
            this.fireConnectedChange(true);
            this.initialUpdate = true;
            this.startUpdateTimer();
        } else {
            new Thread("VMPanel.connect"){

                public void run() {
                    VMPanel.this.proxyClient.connect(VMPanel.this.shouldUseSSL);
                }
            }.start();
        }
    }

    public void disconnect() {
        this.proxyClient.disconnect();
        this.updateFrameTitle();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "connectionState") {
            JConsoleContext.ConnectionState connectionState = (JConsoleContext.ConnectionState)((Object)propertyChangeEvent.getOldValue());
            JConsoleContext.ConnectionState connectionState2 = (JConsoleContext.ConnectionState)((Object)propertyChangeEvent.getNewValue());
            switch (connectionState2) {
                case CONNECTING: {
                    this.onConnecting();
                    break;
                }
                case CONNECTED: {
                    if (this.progressBar != null) {
                        this.progressBar.setIndeterminate(false);
                        this.progressBar.setValue(100);
                    }
                    this.closeOptionPane();
                    this.updateFrameTitle();
                    this.createPluginTabs();
                    this.repaint();
                    this.fireConnectedChange(true);
                    this.initialUpdate = true;
                    this.startUpdateTimer();
                    break;
                }
                case DISCONNECTED: {
                    if (this.progressBar != null) {
                        this.progressBar.setIndeterminate(false);
                        this.progressBar.setValue(0);
                        this.closeOptionPane();
                    }
                    this.vmPanelDied();
                    if (connectionState != JConsoleContext.ConnectionState.CONNECTED) break;
                    this.fireConnectedChange(false);
                }
            }
        }
    }

    private void onConnecting() {
        this.time0 = System.currentTimeMillis();
        JConsole jConsole = (JConsole)SwingUtilities.getWindowAncestor(this);
        String string = this.getConnectionName();
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(this.progressBar);
        Object[] objectArray = new Object[]{"<html><h3>" + VMPanel.getText("connectingTo1", string) + "</h3></html>", jPanel, "<html><b>" + VMPanel.getText("connectingTo2", string) + "</b></html>"};
        this.optionPane = SheetDialog.showOptionDialog(this, objectArray, -1, 1, null, new String[]{VMPanel.getText("Cancel", new Object[0])}, 0);
    }

    private void closeOptionPane() {
        if (this.optionPane != null) {
            new Thread("VMPanel.sleeper"){

                public void run() {
                    long l = System.currentTimeMillis() - VMPanel.this.time0;
                    if (l < 2000L) {
                        try {
                            3.sleep(2000L - l);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            VMPanel.this.optionPane.setVisible(false);
                            VMPanel.this.progressBar = null;
                        }
                    });
                }
            }.start();
        }
    }

    void updateFrameTitle() {
        VMInternalFrame vMInternalFrame = this.getFrame();
        if (vMInternalFrame != null) {
            String string = this.getDisplayName();
            if (!this.proxyClient.isConnected()) {
                string = VMPanel.getText("ConnectionName (disconnected)", string);
            }
            vMInternalFrame.setTitle(string);
        }
    }

    private VMInternalFrame getFrame() {
        if (this.vmIF == null) {
            this.vmIF = (VMInternalFrame)SwingUtilities.getAncestorOfClass(VMInternalFrame.class, this);
        }
        return this.vmIF;
    }

    synchronized List<Tab> getTabs() {
        ArrayList<Tab> arrayList = new ArrayList<Tab>();
        int n = this.getTabCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.getComponentAt(i);
            if (!(component instanceof Tab)) continue;
            arrayList.add((Tab)component);
        }
        return arrayList;
    }

    private void startUpdateTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        TimerTask timerTask = new TimerTask(){

            public void run() {
                VMPanel.this.update();
            }
        };
        String string = "Timer-" + this.getConnectionName();
        this.timer = new Timer(string, true);
        this.timer.schedule(timerTask, 0L, (long)this.updateInterval);
    }

    private void vmPanelDied() {
        String string;
        String string2;
        String string3;
        this.disconnect();
        JConsole jConsole = (JConsole)SwingUtilities.getWindowAncestor(this);
        final String string4 = VMPanel.getText("Connect", new Object[0]);
        final String string5 = VMPanel.getText("Reconnect", new Object[0]);
        final String string6 = VMPanel.getText("Insecure", new Object[0]);
        String string7 = VMPanel.getText("Cancel", new Object[0]);
        if (this.wasConnected) {
            this.wasConnected = false;
            string3 = VMPanel.getText("connectionLost1", new Object[0]);
            string2 = VMPanel.getText("connectionLost2", this.getConnectionName());
            string = string5;
        } else if (this.shouldUseSSL) {
            string3 = VMPanel.getText("connectionFailedSSL1", new Object[0]);
            string2 = VMPanel.getText("connectionFailedSSL2", this.getConnectionName());
            string = string6;
        } else {
            string3 = VMPanel.getText("connectionFailed1", new Object[0]);
            string2 = VMPanel.getText("connectionFailed2", this.getConnectionName());
            string = string4;
        }
        JOptionPane jOptionPane = SheetDialog.showOptionDialog(this, "<html><h3>" + string3 + "</h3>" + "<b>" + string2 + "</b>", -1, 2, null, new String[]{string, string7}, 0);
        jOptionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("value")) {
                    Object object = propertyChangeEvent.getNewValue();
                    if (object == string5 || object == string4) {
                        VMPanel.this.connect();
                    } else if (object == string6) {
                        VMPanel.this.shouldUseSSL = false;
                        VMPanel.this.connect();
                    } else if (!VMPanel.this.everConnected) {
                        try {
                            VMPanel.this.getFrame().setClosed(true);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.isConnected()) {
                if (this.wasConnected) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            VMPanel.this.vmPanelDied();
                        }
                    });
                }
                this.wasConnected = false;
                return;
            }
            this.wasConnected = true;
            this.everConnected = true;
            this.proxyClient.flush();
            List<Tab> list = this.getTabs();
            final int n = list.size();
            for (int i = 0; i < n; ++i) {
                final int n2 = i;
                try {
                    if (this.proxyClient.isDead()) continue;
                    list.get(n2).update();
                    if (!this.initialUpdate) continue;
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            VMPanel.this.setEnabledAt(n2, true);
                        }
                    });
                    continue;
                }
                catch (Exception exception) {
                    if (!this.initialUpdate) continue;
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            VMPanel.this.setEnabledAt(n2, false);
                        }
                    });
                }
            }
            for (JConsolePlugin jConsolePlugin : this.plugins.keySet()) {
                SwingWorker<?, ?> swingWorker = jConsolePlugin.newSwingWorker();
                SwingWorker<?, ?> swingWorker2 = this.plugins.get(jConsolePlugin);
                if (swingWorker2 != null && !swingWorker2.isDone() || swingWorker != null && swingWorker.getState() != SwingWorker.StateValue.PENDING) continue;
                this.plugins.put(jConsolePlugin, swingWorker);
                if (swingWorker == null) continue;
                swingWorker.execute();
            }
            if (this.initialUpdate) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        int n2 = VMPanel.this.getSelectedIndex();
                        if (n2 < 0 || !VMPanel.this.isEnabledAt(n2)) {
                            for (int i = 0; i < n; ++i) {
                                if (!VMPanel.this.isEnabledAt(i)) continue;
                                VMPanel.this.setSelectedIndex(i);
                                break;
                            }
                        }
                    }
                });
                this.initialUpdate = false;
            }
        }
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getPassword() {
        return this.password;
    }

    public String getConnectionName() {
        return this.proxyClient.connectionName();
    }

    public String getDisplayName() {
        return this.proxyClient.getDisplayName();
    }

    private static String getText(String string, Object ... objectArray) {
        return Resources.getText(string, objectArray);
    }

    private void createPluginTabs() {
        if (!this.pluginTabsAdded) {
            for (JConsolePlugin jConsolePlugin : this.plugins.keySet()) {
                Map<String, JPanel> map = jConsolePlugin.getTabs();
                for (Map.Entry<String, JPanel> entry : map.entrySet()) {
                    this.addTab(entry.getKey(), entry.getValue());
                }
            }
            this.pluginTabsAdded = true;
        }
    }

    private void fireConnectedChange(boolean bl) {
        for (Tab tab : this.getTabs()) {
            tab.firePropertyChange("connectionState", !bl, bl);
        }
    }

    static {
        tabInfos.add(new TabInfo(OverviewTab.class, OverviewTab.getTabName(), true));
        tabInfos.add(new TabInfo(MemoryTab.class, MemoryTab.getTabName(), true));
        tabInfos.add(new TabInfo(ThreadTab.class, ThreadTab.getTabName(), true));
        tabInfos.add(new TabInfo(ClassTab.class, ClassTab.getTabName(), true));
        tabInfos.add(new TabInfo(SummaryTab.class, SummaryTab.getTabName(), true));
        tabInfos.add(new TabInfo(MBeansTab.class, MBeansTab.getTabName(), true));
        connectedIcon16 = new ImageIcon(VMPanel.class.getResource("resources/connected16.png"));
        connectedIcon24 = new ImageIcon(VMPanel.class.getResource("resources/connected24.png"));
        disconnectedIcon16 = new ImageIcon(VMPanel.class.getResource("resources/disconnected16.png"));
        disconnectedIcon24 = new ImageIcon(VMPanel.class.getResource("resources/disconnected24.png"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TabInfo {
        Class<? extends Tab> tabClass;
        String name;
        boolean tabVisible;

        TabInfo(Class<? extends Tab> clazz, String string, boolean bl) {
            this.tabClass = clazz;
            this.name = string;
            this.tabVisible = bl;
        }
    }
}

