/*
 * Decompiled with CFR 0.152.
 */
package wj.ap.action;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.dom4j.Element;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import wj.ap.action.ChangeNameAction;
import wj.ap.action.CopyChapterAction;
import wj.ap.action.CreateChapterAction;
import wj.ap.action.CreateNoteAction;
import wj.ap.action.CreateNovelAction;
import wj.ap.action.CreateOutlineFileAction;
import wj.ap.action.CreateScriptAction;
import wj.ap.action.CreateTeleplayAction;
import wj.ap.action.DeleteAction;
import wj.ap.action.ExportAction;
import wj.ap.action.ImportAction;
import wj.ap.explorer.EnableAction;
import wj.ap.explorer.ExplorerModelHelper;
import wj.ap.explorer.ExplorerView;
import wj.ap.file.editor.ITextEditor;
import wj.ap.sys.Activator;
import wj.ap.util.WJ;

public class ActionFactory4PopMenu {
    private IAction createNovelAction = new CreateNovelAction();
    private IAction createTeleplayAction = new CreateTeleplayAction();
    private IAction createNoteAction = new CreateNoteAction();
    private IAction createThemeAction = new CreateOutlineFileAction("theme");
    private IAction createRoleAction = new CreateOutlineFileAction("roles");
    private IAction createStorylineAction = new CreateOutlineFileAction("storylines");
    private IAction createChapterAction = new CreateChapterAction();
    private IAction createScriptAction = new CreateScriptAction();
    private IAction copyChapterAction = new CopyChapterAction();
    private IAction changeNameAction = new ChangeNameAction();
    private IAction deleteAction = new DeleteAction();
    private IAction importAction = new ImportAction();
    private IAction exportAction = new ExportAction();
    private static ActionFactory4PopMenu factory;
    private EnableAction enableAction;

    private ActionFactory4PopMenu() {
    }

    public static ActionFactory4PopMenu getInstance() {
        if (factory == null) {
            factory = new ActionFactory4PopMenu();
        }
        return factory;
    }

    public void initEnable() {
        this.createNoteAction.setEnabled(false);
        this.createChapterAction.setEnabled(false);
        this.createScriptAction.setEnabled(false);
        this.exportAction.setEnabled(false);
        this.changeNameAction.setEnabled(false);
        this.deleteAction.setEnabled(false);
        this.createThemeAction.setEnabled(false);
        this.createRoleAction.setEnabled(false);
        this.createStorylineAction.setEnabled(false);
        this.enableAction = new EnableAction();
        boolean isHasStoryNode = this.enableAction.isHasStoryNode();
        this.exportAction.setEnabled(isHasStoryNode);
    }

    public void setEnable4Explorer() {
        boolean isHasStoryNode = this.enableAction.isHasStoryNode();
        this.exportAction.setEnabled(isHasStoryNode);
        IViewPart view = WJ.getActivePage().findView(ExplorerView.class.getName());
        if (view == null) {
            return;
        }
        ExplorerView explorerView = (ExplorerView)view;
        boolean isHasSelectNode = this.enableAction.isHasSelectNode(explorerView.getTree());
        this.createNoteAction.setEnabled(isHasSelectNode);
        this.changeNameAction.setEnabled(isHasSelectNode);
        this.deleteAction.setEnabled(isHasSelectNode);
        if (isHasSelectNode) {
            TreeItem item = explorerView.getTree().getSelection()[0];
            Element element = (Element)item.getData();
            String storyId = element.attributeValue("location").replace(File.separator, ";").split(";")[0];
            Element storyElement = ExplorerModelHelper.getElement(storyId);
            if (storyElement == null) {
                return;
            }
            if (storyElement.getName().equals("novel")) {
                this.createChapterAction.setEnabled(true);
                this.createScriptAction.setEnabled(false);
                this.enableAction.setEnableOutlineFile(explorerView.getTree(), this.createThemeAction, this.createRoleAction, this.createStorylineAction);
            } else if (storyElement.getName().equals("teleplay")) {
                this.createChapterAction.setEnabled(false);
                this.createScriptAction.setEnabled(true);
                this.enableAction.setEnableOutlineFile(explorerView.getTree(), this.createThemeAction, this.createRoleAction, this.createStorylineAction);
            } else if (storyElement.getName().equals("essay")) {
                this.createChapterAction.setEnabled(false);
                this.createScriptAction.setEnabled(false);
                this.createThemeAction.setEnabled(false);
                this.createRoleAction.setEnabled(false);
                this.createStorylineAction.setEnabled(false);
            }
        }
    }

    public void setEnable4Editor() {
        IEditorPart editor;
        IWorkbenchPage page = WJ.getActivePage();
        boolean b = true;
        b = page == null ? false : (editor = page.getActiveEditor()) != null;
        this.copyChapterAction.setEnabled(b);
    }

    public void addPartListener() {
        WJ.getActivePage().addPartListener(new IPartListener(){

            public void partOpened(IWorkbenchPart part) {
                if (part instanceof ITextEditor) {
                    ActionFactory4PopMenu.this.setEnable4Editor();
                }
                if (part instanceof ExplorerView) {
                    ActionFactory4PopMenu.this.setEnable4Explorer();
                }
            }

            public void partDeactivated(IWorkbenchPart part) {
                if (part instanceof ITextEditor) {
                    ActionFactory4PopMenu.this.setEnable4Editor();
                }
            }

            public void partClosed(IWorkbenchPart part) {
                if (part instanceof ITextEditor) {
                    ActionFactory4PopMenu.this.setEnable4Editor();
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
                if (part instanceof ExplorerView) {
                    ActionFactory4PopMenu.this.setEnable4Explorer();
                }
            }

            public void partActivated(IWorkbenchPart part) {
                if (part instanceof ITextEditor) {
                    ActionFactory4PopMenu.this.setEnable4Editor();
                }
                if (part instanceof ExplorerView) {
                    ActionFactory4PopMenu.this.setEnable4Explorer();
                }
            }
        });
    }

    private ImageDescriptor getImg(String modelName) {
        String filePath = null;
        filePath = "icons/" + modelName + "16.png";
        try {
            URL u = new URL(Activator.getDefault().getBundle().getEntry("/"), filePath);
            return ImageDescriptor.createFromURL((URL)u);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public IAction getCreateTeleplayAction() {
        this.createTeleplayAction.setImageDescriptor(this.getImg("createTeleplay"));
        return this.createTeleplayAction;
    }

    public IAction getCreateNoteAction() {
        this.createNoteAction.setImageDescriptor(this.getImg("createNote"));
        return this.createNoteAction;
    }

    public IAction getCreateThemeAction() {
        this.createThemeAction.setImageDescriptor(this.getImg("createTheme"));
        return this.createThemeAction;
    }

    public IAction getCreateRoleAction() {
        this.createRoleAction.setImageDescriptor(this.getImg("createRoles"));
        return this.createRoleAction;
    }

    public IAction getCreateStorylineAction() {
        this.createStorylineAction.setImageDescriptor(this.getImg("createStoryline"));
        return this.createStorylineAction;
    }

    public IAction getCreateChapterAction() {
        this.createChapterAction.setImageDescriptor(this.getImg("createChapter"));
        return this.createChapterAction;
    }

    public IAction getCreateScriptAction() {
        this.createScriptAction.setImageDescriptor(this.getImg("createScript"));
        return this.createScriptAction;
    }

    public IAction getCopyChapterAction() {
        this.copyChapterAction.setImageDescriptor(this.getImg("copy"));
        return this.copyChapterAction;
    }

    public IAction getChangeNameAction() {
        this.changeNameAction.setImageDescriptor(this.getImg("rename"));
        return this.changeNameAction;
    }

    public IAction getDeleteAction() {
        this.deleteAction.setImageDescriptor(this.getImg("delete"));
        return this.deleteAction;
    }

    public IAction getImportAction() {
        this.importAction.setImageDescriptor(this.getImg("import"));
        return this.importAction;
    }

    public IAction getExportAction() {
        this.exportAction.setImageDescriptor(this.getImg("export"));
        return this.exportAction;
    }

    public IAction getCreateNovelAction() {
        this.createNovelAction.setImageDescriptor(this.getImg("createNovel"));
        return this.createNovelAction;
    }

    public EnableAction getEnableAction() {
        return this.enableAction;
    }
}

